"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SiteAddress = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        defaultBankId: {
            entityType: 'entityType',
            site: 'site',
            bankId: 'defaultBankId',
            address: 'code',
        },
        country: {
            code: 'country',
        },
    },
};
let SiteAddress = class SiteAddress extends xtrem_core_1.Node {
};
exports.SiteAddress = SiteAddress;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], SiteAddress.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], SiteAddress.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPADES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPABID',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.SiteBankDetail,
    })
], SiteAddress.prototype, "defaultBankId", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADDFLG',
    })
], SiteAddress.prototype, "isDefault", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "zipCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "city", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "state", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], SiteAddress.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "countryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYWEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "website", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXTNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SiteAddress.prototype, "externalIdentifier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADRVAL',
    })
], SiteAddress.prototype, "isValid", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.SiteAddressAddressEmails,
    })
], SiteAddress.prototype, "addressEmails", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.SiteAddressAddressLines,
    })
], SiteAddress.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.SiteAddressAddressPhoneNumbers,
    })
], SiteAddress.prototype, "addressPhoneNumbers", void 0);
exports.SiteAddress = SiteAddress = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPADDRESS',
        keyPropertyNames: ['entityType', 'site', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    site: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entityType', 'site', 'code'],
        }),
        getFilters() {
            return [{ entityType: 'site' }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SiteAddress);
//# sourceMappingURL=site-address.js.map