import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, TextStream, Collection } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class ShipToCustomerAddress extends Node {
    readonly customer: Reference<sageX3MasterData.nodes.Customer>;
    readonly shipToAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly company: Reference<sageX3System.nodes.Company | null>;
    readonly isActive: Promise<boolean>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly receiptSite: Reference<sageX3System.nodes.Site | null>;
    readonly language: Reference<sageX3System.nodes.Language | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly deliveryLeadTime: Promise<integer | null>;
    readonly isMondayWorkday: Promise<boolean>;
    readonly isTuesdayWorkday: Promise<boolean>;
    readonly isWednesdayWorkday: Promise<boolean>;
    readonly isThursdayWorkday: Promise<boolean>;
    readonly isFridayWorkday: Promise<boolean>;
    readonly isSaturdayWorkday: Promise<boolean>;
    readonly isSundayWorkday: Promise<boolean>;
    readonly unavailablePeriod: Reference<sageX3MasterData.nodes.UnavailablePeriods | null>;
    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
    readonly europeanUnionVatNumber: Promise<string>;
    readonly incotermTown: Promise<string>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.Address | null>;
    readonly geographicCode: Promise<string>;
    readonly insideCityLimits: Promise<string>;
    readonly taxExemptionNumber: Promise<string>;
    readonly exemptionFlag: Promise<string>;
    readonly pickingHeaderTextKey: Promise<string>;
    readonly deliveryHeaderTextKey: Promise<string>;
    readonly mustPrintPickTicket: Promise<boolean>;
    readonly mustPrintPackingSlip: Promise<boolean>;
    readonly entityUse: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly pickingHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly deliveryHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly deliveryHeaderText: Promise<TextStream>;
    readonly pickingHeaderText: Promise<TextStream>;
    readonly companyNames: Collection<sageX3MasterData.nodes.ShipToCustomerAddressCompanyNames>;
    readonly salesReps: Collection<sageX3MasterData.nodes.ShipToCustomerAddressSalesReps>;
}
//# sourceMappingURL=ship-to-customer-address.d.ts.map