"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProspectContact = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        prospect: {
            code: 'prospect',
        },
        code: {
            code: 'code',
        },
        role: {
            glossaryId() {
                return 906;
            },
            code: 'role',
        },
        contactRelationship: {
            code: 'code',
        },
    },
};
const compositeReferences = {
    contactRelationship: {
        addressLines: 'addressLines',
        relationshipCellPhone: 'cellPhone',
        relationshipCity: 'city',
        relationshipCountry: 'country',
        relationshipCountryName: 'countryName',
        relationshipDateOfBirth: 'dateOfBirth',
        relationshipEmail: 'email',
        relationshipFax: 'fax',
        relationshipFirstName: 'firstName',
        relationshipFullNameSearchKey: 'fullNameSearchKey',
        relationshipIsMailingProhibited: 'isMailingProhibited',
        relationshipLandline: 'landline',
        relationshipLanguage: 'language',
        relationshipLastName: 'lastName',
        relationshipProfessionalCategory: 'professionalCategory',
        relationshipState: 'state',
        relationshipTitle: 'title',
        relationshipType: 'type',
        relationshipZipCode: 'zipCode',
    },
};
let ProspectContact = class ProspectContact extends xtrem_core_1.Node {
};
exports.ProspectContact = ProspectContact;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], ProspectContact.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Prospect,
    })
], ProspectContact.prototype, "prospect", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCNCRM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], ProspectContact.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTFNC',
        dataType: () => sageX3MasterData.enums.functionContactDatatype,
    })
], ProspectContact.prototype, "position", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTSRV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "department", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTMSS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 906,
            },
            control: {
                glossaryId: 906,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ProspectContact.prototype, "role", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "landline", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "fax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "cellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPO',
    })
], ProspectContact.prototype, "isDataProtectionOfficer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], ProspectContact.prototype, "contactRelationship", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ContactRelationshipAddressLines,
        isMutable: true,
    })
], ProspectContact.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTMOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipCellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipCity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], ProspectContact.prototype, "relationshipCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTBIR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProspectContact.prototype, "relationshipDateOfBirth", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTEMA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipEmail", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipFax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipFirstName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFULNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipFullNameSearchKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFBDMAG',
    })
], ProspectContact.prototype, "relationshipIsMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTETS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipLandline", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTLAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], ProspectContact.prototype, "relationshipLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTLNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipLastName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTCSP',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ProspectContact.prototype, "relationshipProfessionalCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipState", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTTL',
        dataType: () => sageX3System.enums.titleDatatype,
    })
], ProspectContact.prototype, "relationshipTitle", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTYP',
        dataType: () => sageX3System.enums.contactTypeDatatype,
    })
], ProspectContact.prototype, "relationshipType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZIP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectContact.prototype, "relationshipZipCode", void 0);
exports.ProspectContact = ProspectContact = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CONTACT',
        keyPropertyNames: ['entityType', 'prospect', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    prospect: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['entityType', 'prospect'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProspectContact);
//# sourceMappingURL=prospect-contact.js.map