"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProspectAddress = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        prospect: {
            code: 'prospect',
        },
        country: {
            code: 'country',
        },
    },
};
let ProspectAddress = class ProspectAddress extends xtrem_core_1.Node {
};
exports.ProspectAddress = ProspectAddress;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], ProspectAddress.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Prospect,
    })
], ProspectAddress.prototype, "prospect", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPADES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'BPABID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "defaultBankId", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADDFLG',
    })
], ProspectAddress.prototype, "isDefault", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "zipCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "city", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "state", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], ProspectAddress.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "countryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYWEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProspectAddress.prototype, "website", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.ProspectAddressAddressEmails,
    })
], ProspectAddress.prototype, "addressEmails", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.ProspectAddressAddressLines,
    })
], ProspectAddress.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.ProspectAddressAddressPhoneNumbers,
    })
], ProspectAddress.prototype, "addressPhoneNumbers", void 0);
exports.ProspectAddress = ProspectAddress = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPADDRESS',
        keyPropertyNames: ['entityType', 'prospect', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    prospect: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entityType', 'prospect', 'code'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PptActivityCode],
        getFilters() {
            return [{ prospect: { code: { isProspect: true } } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProspectAddress);
//# sourceMappingURL=prospect-address.js.map