import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class ProductSite extends Node {
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly isBeingCounted: Promise<boolean>;
    readonly countWorksheet: Promise<string>;
    readonly abcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
    readonly isLocationManaged: Promise<boolean>;
    readonly stockWithdrawalMode: Promise<sageX3MasterData.enums.StockWithdrawal | null>;
    readonly countManagementMode: Promise<sageX3MasterData.enums.Count | null>;
    readonly trendProfile: Promise<string>;
    readonly numberOfStockCoverageWeeks: Promise<integer | null>;
    readonly multilevelLeadTime: Promise<decimal | null>;
    readonly qualityControlLeadTime: Promise<decimal | null>;
    readonly planningFirmHorizon: Promise<integer | null>;
    readonly planningFirmHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly planningDemandHorizon: Promise<integer | null>;
    readonly planningDemandHorizonTimeUnit: Promise<sageX3MasterData.enums.LeadTimeUnit | null>;
    readonly reorderLeadTime: Promise<decimal | null>;
    readonly productionLeadTime: Promise<decimal | null>;
    readonly pickingLeadTime: Promise<decimal | null>;
    readonly reductionFactor: Promise<integer | null>;
    readonly reorderingPeriodicity: Promise<integer | null>;
    readonly reorderingSuggestionType: Promise<sageX3MasterData.enums.SuggestionType | null>;
    readonly reorderingSite: Reference<sageX3System.nodes.Site | null>;
    readonly reorderingPolicy: Promise<string>;
    readonly safetyStock: Promise<decimal | null>;
    readonly calculatedSafetyStock: Promise<decimal | null>;
    readonly reorderingThreshold: Promise<decimal | null>;
    readonly calculatedReorderingThreshold: Promise<decimal | null>;
    readonly reorderingMaximumStock: Promise<decimal | null>;
    readonly calculatedReorderingMaximumStock: Promise<decimal | null>;
    readonly economicOrderQuantity: Promise<decimal | null>;
    readonly calculatedEconomicOrderQuantity: Promise<decimal | null>;
    readonly technicalLotQuantity: Promise<decimal | null>;
    readonly shrinkagePercentage: Promise<decimal | null>;
    readonly planner: Reference<sageX3System.nodes.User | null>;
    readonly buyer: Reference<sageX3System.nodes.User | null>;
    readonly standardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly revisedStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly budgetStandardCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly simulatedCostUpdate: Promise<sageX3MasterData.enums.PriceUpdateMode | null>;
    readonly productionRouting: Promise<string>;
    readonly costRouting: Promise<string>;
    readonly roughCut: Promise<string>;
    readonly productionRoutingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
    readonly costRoutingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
    readonly roughCutCapacityPlanningRoutingCode: Reference<sageX3MasterData.nodes.BomRouting | null>;
    readonly isReleasedIfShortage: Promise<boolean>;
    readonly isShrinkedWithRelease: Promise<boolean>;
    readonly yearOfLastMonthlyUpdate: Promise<integer | null>;
    readonly monthOfLastMonthlyUpdate: Promise<integer | null>;
    readonly lastAnnualUpdate: Promise<integer | null>;
    readonly automaticClosingPercentage: Promise<decimal | null>;
    readonly configurationCode: Promise<string>;
    readonly storageHandling: Promise<string>;
    readonly weighingAccessCode: Promise<string>;
    readonly weighingTolerance: Promise<decimal | null>;
    readonly productTolerance: Promise<decimal | null>;
    readonly valuationMethod: Promise<string>;
    readonly prorataQuantityAdjustment: Promise<decimal | null>;
    readonly protectionWip: Promise<boolean>;
    readonly packagingCapacity: Promise<decimal | null>;
    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly assignmentRule: Promise<string>;
    readonly isStockDetailedInPacking: Promise<boolean>;
    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
    readonly qualityControlAccessCode: Promise<string>;
    readonly qualityControlFrequency: Promise<integer | null>;
    readonly numberOfEntriesSinceLastQualityControl: Promise<integer | null>;
    readonly sampling: Promise<sageX3MasterData.enums.SamplingType | null>;
    readonly samplingMode: Promise<sageX3MasterData.enums.SamplingMode | null>;
    readonly samplingGeneralCheckLevel: Promise<sageX3MasterData.enums.GeneralControlLevel | null>;
    readonly samplingAcceptableQualityLevel: Promise<sageX3MasterData.enums.AcceptableQualityLevel | null>;
    readonly qualityControlFrequencyToReview: Promise<integer | null>;
    readonly qualityEntriesProcess: Promise<integer | null>;
    readonly recontrolLeadTime: Promise<integer | null>;
    readonly newStockStatusAfterRecontrol: Promise<string>;
    readonly useByDateCoefficient: Promise<decimal | null>;
    readonly orderWarehouse: Promise<string>;
    readonly workOrderWarehouse: Promise<string>;
    readonly shippingWarehouse: Promise<string>;
    readonly materialConsumptionsWarehouse: Promise<string>;
    readonly internalMovementWarehouse: Promise<string>;
    readonly subcontractShipmentWarehouse: Promise<string>;
    readonly subcontractConsumptionWarehouse: Promise<string>;
    readonly isPackingManaged: Promise<boolean>;
    readonly freightClass: Promise<string>;
    readonly freightCommodityCode: Promise<string>;
    readonly isLicensePlateNumberManaged: Promise<boolean>;
    readonly products: Collection<sageX3MasterData.nodes.Product>;
}
//# sourceMappingURL=product-site.d.ts.map