"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductCategoryStatisticalGroups = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'STI'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            stockSite: 'stockSite',
            code: 'code',
        },
        statisticalGroup: {
            async glossaryId() {
                return typesLib.add(typesLib.sub((await this.denormalizedIndex), 1), 20);
            },
            code: 'statisticalGroup',
        },
    },
};
let ProductCategoryStatisticalGroups = class ProductCategoryStatisticalGroups extends xtrem_core_1.Node {
};
exports.ProductCategoryStatisticalGroups = ProductCategoryStatisticalGroups;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], ProductCategoryStatisticalGroups.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STOFCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryStatisticalGroups.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TCLCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryStatisticalGroups.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductCategory,
    })
], ProductCategoryStatisticalGroups.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TSICOD',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], ProductCategoryStatisticalGroups.prototype, "statisticalGroup", void 0);
exports.ProductCategoryStatisticalGroups = ProductCategoryStatisticalGroups = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITMCATEG',
        keyPropertyNames: ['denormalizedIndex', 'stockSite', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], ProductCategoryStatisticalGroups);
//# sourceMappingURL=product-category-statistical-groups.js.map