"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobileAutomationSetup = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        stockLabel: {
            reportName: 'stockLabel',
        },
        productionLabel: {
            reportName: 'productionLabel',
        },
    },
};
let MobileAutomationSetup = class MobileAutomationSetup extends xtrem_core_1.Node {
};
exports.MobileAutomationSetup = MobileAutomationSetup;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], MobileAutomationSetup.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRIT1',
        dataType: () => sageX3MasterData.enums.productSearchCriteriaDatatype,
    })
], MobileAutomationSetup.prototype, "criteria1", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRIT2',
        dataType: () => sageX3MasterData.enums.productSearchCriteriaDatatype,
    })
], MobileAutomationSetup.prototype, "criteria2", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOLAB',
        columnType: 'string',
        node: () => sageX3System.nodes.GenericPrintReport,
    })
], MobileAutomationSetup.prototype, "stockLabel", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PROLAB',
        columnType: 'string',
        node: () => sageX3System.nodes.GenericPrintReport,
    })
], MobileAutomationSetup.prototype, "productionLabel", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ALWLABDES',
    })
], MobileAutomationSetup.prototype, "isAlwaysLabelDestination", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DISSTKQTY',
    })
], MobileAutomationSetup.prototype, "isTheoreticalQuantityDisplayed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOALOC',
    })
], MobileAutomationSetup.prototype, "isLocationPreloaded", void 0);
exports.MobileAutomationSetup = MobileAutomationSetup = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PARADC',
        keyPropertyNames: ['site'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.AdcActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], MobileAutomationSetup);
//# sourceMappingURL=mobile-automation-setup.js.map