import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, date, integer, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class Customer extends Node {
    readonly code: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly customerCategory: Reference<sageX3MasterData.nodes.CustomerCategory | null>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly billToCustomerAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly payByCustomer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly payByCustomerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly groupCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly riskCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly defaultAddress: Reference<sageX3MasterData.nodes.CustomerAddress | null>;
    readonly defaultShipToAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
    readonly defaultContact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly isActive: Promise<boolean>;
    readonly isProspect: Promise<boolean>;
    readonly ourSupplierCode: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly commissionCategory: Promise<sageX3MasterData.enums.CommissionCategory | null>;
    readonly exemptionTaxNumber: Promise<string>;
    readonly priceOrAmountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly creditControl: Promise<sageX3MasterData.enums.WorkInProgressControl | null>;
    readonly authorizedCreditAmount: Promise<decimal | null>;
    readonly minimumOrderAmount: Promise<decimal | null>;
    readonly creditInsuranceAmount: Promise<decimal | null>;
    readonly insuranceDate: Promise<date | null>;
    readonly insuranceCompany: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly reminderType: Promise<sageX3MasterData.enums.ReminderType | null>;
    readonly minimumReminderAmount: Promise<decimal | null>;
    readonly canBeMatched: Promise<boolean>;
    readonly orderHeaderTextKey: Promise<string>;
    readonly invoiceHeaderTextKey: Promise<string>;
    readonly isLoanAllowed: Promise<boolean>;
    readonly mustPrintAcknowledgment: Promise<boolean>;
    readonly isOrderClosingAllowed: Promise<boolean>;
    readonly mustContainOneOrderPerDelivery: Promise<boolean>;
    readonly businessSector: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly prospectOrigin: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly tokenCredit: Promise<integer | null>;
    readonly manualAdditionalToken: Promise<integer | null>;
    readonly totalTokenCredit: Promise<integer | null>;
    readonly necessaryTokensForServiceContract: Promise<integer | null>;
    readonly firstContactDate: Promise<date | null>;
    readonly firstOrderDate: Promise<date | null>;
    readonly lastQuoteDate: Promise<date | null>;
    readonly lastContactDate: Promise<date | null>;
    readonly nextContactDate: Promise<date | null>;
    readonly customerAbcClass: Promise<sageX3MasterData.enums.ProductAbcClass | null>;
    readonly printTemplate: Reference<sageX3MasterData.nodes.PrintTemplate | null>;
    readonly initialDateSinceCustomer: Promise<date | null>;
    readonly unavailablePaymentPeriod: Reference<sageX3MasterData.nodes.UnavailablePeriods | null>;
    readonly isSubjectToTax: Promise<boolean>;
    readonly isEfatElectronicInvoicingAllowed: Promise<boolean>;
    readonly contact: Reference<sageX3MasterData.nodes.CustomerContact | null>;
    readonly startDateforElectronicInvoice: Promise<date | null>;
    readonly isElectronicInvoiceAllowed: Promise<boolean>;
    readonly addresses: Collection<sageX3MasterData.nodes.CustomerAddress>;
    readonly contacts: Collection<sageX3MasterData.nodes.CustomerContact>;
    readonly bankDetails: Collection<sageX3MasterData.nodes.CustomerBankDetail>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly shipToCustomers: Collection<sageX3MasterData.nodes.ShipToCustomerAddress>;
    readonly orderHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly invoiceHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly acronym: Promise<string>;
    readonly businessPartnerSite: Reference<sageX3System.nodes.Site | null>;
    readonly cfonbPaymentMethod: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly companyName1: Promise<string>;
    readonly companyName2: Promise<string>;
    readonly companyNames: Collection<sageX3MasterData.nodes.BusinessPartnerCompanyNames>;
    readonly consolidationCode: Promise<string>;
    readonly consolidationGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
    readonly consolidationPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly country: Reference<sageX3Structure.nodes.Country | null>;
    readonly customerOrSupplierOriginCategory: Promise<string>;
    readonly documentType: Promise<sageX3MasterData.enums.DocumentType | null>;
    readonly economicOperatorRegistrationAndIdNumber: Promise<string>;
    readonly electronicAddress: Promise<string>;
    readonly electronicInvoiceType: Promise<sageX3MasterData.enums.ElectronicInvoiceType | null>;
    readonly europeanUnionVatNumber: Promise<string>;
    readonly fiscalCode: Promise<string>;
    readonly invoiceHeaderText: Promise<TextStream>;
    readonly isCashExcluded: Promise<boolean>;
    readonly isIntersite: Promise<boolean>;
    readonly isMailingProhibited: Promise<boolean>;
    readonly isPhysicalPerson: Promise<boolean>;
    readonly isPublicSector: Promise<boolean>;
    readonly isServiceCaller: Promise<boolean>;
    readonly isServiceSupplier: Promise<boolean>;
    readonly italianTaxNumber: Promise<string>;
    readonly language: Reference<sageX3System.nodes.Language>;
    readonly nonResidentAccount: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly orderHeaderText: Promise<TextStream>;
    readonly registrationNumber: Promise<string>;
    readonly relatedCompany: Promise<sageX3MasterData.enums.RelatedCompanySettings | null>;
    readonly reportAccessCode: Reference<sageX3System.nodes.Access | null>;
    readonly routingCode: Promise<string>;
    readonly serviceCode: Promise<string>;
    readonly shortCompanyName: Promise<string>;
    readonly siteIdentificationNumber: Promise<string>;
    readonly standardIndustrialClassificationCode: Promise<string>;
    readonly vatNumber: Promise<string>;
    readonly cashTaxRules: Collection<sageX3MasterData.nodes.CustomerCashTaxRules>;
    readonly paymentDays: Collection<sageX3MasterData.nodes.CustomerPaymentDays>;
    readonly salesReps: Collection<sageX3MasterData.nodes.CustomerSalesReps>;
    readonly statisticalGroups: Collection<sageX3MasterData.nodes.CustomerStatisticalGroups>;
}
//# sourceMappingURL=customer.d.ts.map