"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerStatisticalGroups = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'STC'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            code: 'code',
        },
        value: {
            async glossaryId() {
                return typesLib.add(typesLib.sub((await this.denormalizedIndex), 1), 30);
            },
            code: 'value',
        },
    },
};
let CustomerStatisticalGroups = class CustomerStatisticalGroups extends xtrem_core_1.Node {
};
exports.CustomerStatisticalGroups = CustomerStatisticalGroups;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], CustomerStatisticalGroups.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'BPCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerStatisticalGroups.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], CustomerStatisticalGroups.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TSCCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], CustomerStatisticalGroups.prototype, "value", void 0);
exports.CustomerStatisticalGroups = CustomerStatisticalGroups = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPCUSTOMER',
        keyPropertyNames: ['denormalizedIndex', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], CustomerStatisticalGroups);
//# sourceMappingURL=customer-statistical-groups.js.map