"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerAddress = void 0;
const sageX3Structure = require("@sage/x3-structure");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        customer: {
            code: 'customer',
        },
        defaultBankId: {
            entityType: 'entityType',
            customer: 'customer',
            bankId: 'defaultBankId',
            address: 'code',
        },
        country: {
            code: 'country',
        },
    },
};
let CustomerAddress = class CustomerAddress extends xtrem_core_1.Node {
};
exports.CustomerAddress = CustomerAddress;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], CustomerAddress.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Customer,
    })
], CustomerAddress.prototype, "customer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPADES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPABID',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CustomerBankDetail,
    })
], CustomerAddress.prototype, "defaultBankId", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADDFLG',
    })
], CustomerAddress.prototype, "isDefault", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "zipCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "city", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "state", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], CustomerAddress.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "countryName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYWEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "website", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXTNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CustomerAddress.prototype, "externalIdentifier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ADRVAL',
    })
], CustomerAddress.prototype, "isValid", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerAddressAddressEmails,
    })
], CustomerAddress.prototype, "addressEmails", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerAddressAddressLines,
    })
], CustomerAddress.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.CustomerAddressAddressPhoneNumbers,
    })
], CustomerAddress.prototype, "addressPhoneNumbers", void 0);
exports.CustomerAddress = CustomerAddress = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPADDRESS',
        keyPropertyNames: ['entityType', 'customer', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    customer: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entityType', 'customer', 'code'],
        }),
        getFilters() {
            return [{ customer: { code: { isCustomer: true } } }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], CustomerAddress);
//# sourceMappingURL=customer-address.js.map