"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyContact = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        code: {
            code: 'code',
        },
        role: {
            glossaryId() {
                return 906;
            },
            code: 'role',
        },
        contactRelationship: {
            code: 'code',
        },
    },
};
const compositeReferences = {
    contactRelationship: {
        addressLines: 'addressLines',
        relationshipCellPhone: 'cellPhone',
        relationshipCity: 'city',
        relationshipCountry: 'country',
        relationshipCountryName: 'countryName',
        relationshipDateOfBirth: 'dateOfBirth',
        relationshipEmail: 'email',
        relationshipFax: 'fax',
        relationshipFirstName: 'firstName',
        relationshipFullNameSearchKey: 'fullNameSearchKey',
        relationshipIsMailingProhibited: 'isMailingProhibited',
        relationshipLandline: 'landline',
        relationshipLanguage: 'language',
        relationshipLastName: 'lastName',
        relationshipProfessionalCategory: 'professionalCategory',
        relationshipState: 'state',
        relationshipTitle: 'title',
        relationshipType: 'type',
        relationshipZipCode: 'zipCode',
    },
};
let CompanyContact = class CompanyContact extends xtrem_core_1.Node {
};
exports.CompanyContact = CompanyContact;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], CompanyContact.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], CompanyContact.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCNCRM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], CompanyContact.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTFNC',
        dataType: () => sageX3MasterData.enums.functionContactDatatype,
    })
], CompanyContact.prototype, "position", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTSRV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "department", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTMSS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 906,
            },
            control: {
                glossaryId: 906,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], CompanyContact.prototype, "role", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "landline", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "fax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "cellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPO',
    })
], CompanyContact.prototype, "isDataProtectionOfficer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], CompanyContact.prototype, "contactRelationship", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ContactRelationshipAddressLines,
        isMutable: true,
    })
], CompanyContact.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTMOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipCellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipCity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], CompanyContact.prototype, "relationshipCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTBIR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], CompanyContact.prototype, "relationshipDateOfBirth", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTEMA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipEmail", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipFax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipFirstName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFULNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipFullNameSearchKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFBDMAG',
    })
], CompanyContact.prototype, "relationshipIsMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTETS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipLandline", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTLAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], CompanyContact.prototype, "relationshipLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTLNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipLastName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTCSP',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], CompanyContact.prototype, "relationshipProfessionalCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipState", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTTL',
        dataType: () => sageX3System.enums.titleDatatype,
    })
], CompanyContact.prototype, "relationshipTitle", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTYP',
        dataType: () => sageX3System.enums.contactTypeDatatype,
    })
], CompanyContact.prototype, "relationshipType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZIP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], CompanyContact.prototype, "relationshipZipCode", void 0);
exports.CompanyContact = CompanyContact = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CONTACT',
        keyPropertyNames: ['entityType', 'company', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    company: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['entityType', 'company'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], CompanyContact);
//# sourceMappingURL=company-contact.js.map