"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessPartner = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        category: {
            code: 'category',
        },
        businessPartnerSite: {
            code: 'businessPartnerSite',
        },
        country: {
            code: 'country',
        },
        currency: {
            code: 'currency',
        },
        language: {
            code: 'language',
        },
        consolidationGroup: {
            group: 'consolidationGroup',
        },
        defaultAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
            code: 'defaultAddress',
        },
        defaultContact: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
            code: 'defaultContact',
        },
        defaultBankId: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
            bankId: 'defaultBankId',
            address: 'defaultAddress',
        },
        bankIdCountry: {
            code: 'bankIdCountry',
        },
        reportAccessCode: {
            access: 'reportAccessCode',
        },
        cfonbPaymentMethod: {
            glossaryId() {
                return 311;
            },
            code: 'cfonbPaymentMethod',
        },
        nonResidentAccount: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
            code: 'nonResidentAccount',
        },
        consolidationPartner: {
            code: 'consolidationPartner',
        },
        mappingCode: {
            code: 'mappingCode',
        },
    },
    collectionJoins: {
        addresses: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
        },
        contacts: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
        },
        bankDetails: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'code',
        },
        companyException: {
            businessPartner: 'code',
        },
    },
};
let BusinessPartner = class BusinessPartner extends xtrem_core_1.Node {
};
exports.BusinessPartner = BusinessPartner;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], BusinessPartner.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BRGCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CustomerCategory,
    })
], BusinessPartner.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BRGOBJ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "customerOrSupplierOriginCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "companyName1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "companyName2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRSHO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "shortCompanyName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], BusinessPartner.prototype, "europeanUnionVatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETFCY',
    })
], BusinessPartner.prototype, "isIntersite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], BusinessPartner.prototype, "businessPartnerSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], BusinessPartner.prototype, "country", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "siteIdentificationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NAF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KfrActivityCode],
    })
], BusinessPartner.prototype, "standardIndustrialClassificationCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], BusinessPartner.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], BusinessPartner.prototype, "language", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRLOG',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartner.prototype, "acronym", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], BusinessPartner.prototype, "italianTaxNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FISCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KitActivityCode],
    })
], BusinessPartner.prototype, "fiscalCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GRUGPY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.SiteGroupings,
    })
], BusinessPartner.prototype, "consolidationGroup", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GRUCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.CslActivityCode],
    })
], BusinessPartner.prototype, "consolidationCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCFLG',
    })
], BusinessPartner.prototype, "isCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSFLG',
    })
], BusinessPartner.prototype, "isSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCNFLG',
        serviceOptions: () => [sageX3System.serviceOptions.CcnActivityCode],
    })
], BusinessPartner.prototype, "isGrantor", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPTFLG',
    })
], BusinessPartner.prototype, "isCarrier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCTFLG',
    })
], BusinessPartner.prototype, "isFactor", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REPFLG',
    })
], BusinessPartner.prototype, "isSalesRep", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRACC',
    })
], BusinessPartner.prototype, "isMiscellaneousBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PPTFLG',
    })
], BusinessPartner.prototype, "isProspect", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRVFLG',
    })
], BusinessPartner.prototype, "isServiceSupplier", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DOOFLG',
    })
], BusinessPartner.prototype, "isServiceCaller", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], BusinessPartner.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTNAM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerContact,
    })
], BusinessPartner.prototype, "defaultContact", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BIDNUM',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerBankDetail,
    })
], BusinessPartner.prototype, "defaultBankId", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BIDCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], BusinessPartner.prototype, "bankIdCountry", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        provides: ['accessCode'],
        isNullable: true,
        columnName: 'ACS',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], BusinessPartner.prototype, "reportAccessCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRFBDMAG',
    })
], BusinessPartner.prototype, "isMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MODPAM',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 311,
            },
            control: {
                glossaryId: 311,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], BusinessPartner.prototype, "cfonbPaymentMethod", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNONREI',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], BusinessPartner.prototype, "nonResidentAccount", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEGETT',
    })
], BusinessPartner.prototype, "isPhysicalPerson", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFOEXD',
        serviceOptions: () => [sageX3System.serviceOptions.CfomActivityCode],
    })
], BusinessPartner.prototype, "isCashExcluded", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DOCTYP',
        dataType: () => sageX3MasterData.enums.documentTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], BusinessPartner.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPPFLG',
    })
], BusinessPartner.prototype, "isPublicSector", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPYREL',
        dataType: () => sageX3MasterData.enums.relatedCompanySettingsDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PbdpoActivityCode],
    })
], BusinessPartner.prototype, "relatedCompany", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSLBPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
        serviceOptions: () => [sageX3System.serviceOptions.PrcslActivityCode],
    })
], BusinessPartner.prototype, "consolidationPartner", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REGNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KzaActivityCode],
    })
], BusinessPartner.prototype, "registrationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VATNO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KzaActivityCode],
    })
], BusinessPartner.prototype, "vatNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EoriActivityCode],
    })
], BusinessPartner.prototype, "economicOperatorRegistrationAndIdNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INTSRVCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartner.prototype, "serviceCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RTGCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartner.prototype, "routingCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EINVTYP',
        dataType: () => sageX3MasterData.enums.electronicInvoiceTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartner.prototype, "electronicInvoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAPCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Mapping,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartner.prototype, "mappingCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ELCADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartner.prototype, "electronicAddress", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], BusinessPartner.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerContact,
        isMutable: true,
        dependsOn: ['code'],
    })
], BusinessPartner.prototype, "contacts", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerBankDetail,
        isMutable: true,
        dependsOn: ['code'],
    })
], BusinessPartner.prototype, "bankDetails", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BusinessPartnerCompanyException,
        isMutable: true,
        serviceOptions: () => [sageX3System.serviceOptions.MulActivityCode],
        dependsOn: ['code'],
    })
], BusinessPartner.prototype, "companyException", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3MasterData.nodes.BusinessPartnerCompanyNames,
    })
], BusinessPartner.prototype, "companyNames", void 0);
exports.BusinessPartner = BusinessPartner = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPARTNER',
        keyPropertyNames: ['code'],
        indexes: [
            {
                orderBy: {
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            denormalizedPropertyColumnSuffix: {
                companyName1: 0,
                companyName2: 1,
            },
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BusinessPartner);
//# sourceMappingURL=business-partner.js.map