"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessPartnerContact = void 0;
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        businessPartner: {
            code: 'businessPartner',
        },
        code: {
            code: 'code',
        },
        role: {
            glossaryId() {
                return 906;
            },
            code: 'role',
        },
        contactRelationship: {
            code: 'code',
        },
    },
};
const compositeReferences = {
    contactRelationship: {
        addressLines: 'addressLines',
        relationshipCellPhone: 'cellPhone',
        relationshipCity: 'city',
        relationshipCountry: 'country',
        relationshipCountryName: 'countryName',
        relationshipDateOfBirth: 'dateOfBirth',
        relationshipEmail: 'email',
        relationshipFax: 'fax',
        relationshipFirstName: 'firstName',
        relationshipFullNameSearchKey: 'fullNameSearchKey',
        relationshipIsMailingProhibited: 'isMailingProhibited',
        relationshipLandline: 'landline',
        relationshipLanguage: 'language',
        relationshipLastName: 'lastName',
        relationshipProfessionalCategory: 'professionalCategory',
        relationshipState: 'state',
        relationshipTitle: 'title',
        relationshipType: 'type',
        relationshipZipCode: 'zipCode',
    },
};
let BusinessPartnerContact = class BusinessPartnerContact extends xtrem_core_1.Node {
};
exports.BusinessPartnerContact = BusinessPartnerContact;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPATYP',
        dataType: () => sageX3Structure.enums.entityTypeDatatype,
    })
], BusinessPartnerContact.prototype, "entityType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPANUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], BusinessPartnerContact.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCNCRM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], BusinessPartnerContact.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTFNC',
        dataType: () => sageX3MasterData.enums.functionContactDatatype,
    })
], BusinessPartnerContact.prototype, "position", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTSRV',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "department", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTMSS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 906,
            },
            control: {
                glossaryId: 906,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], BusinessPartnerContact.prototype, "role", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "defaultAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "landline", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "fax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WEB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "email", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "cellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DPO',
    })
], BusinessPartnerContact.prototype, "isDataProtectionOfficer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ContactRelationship,
    })
], BusinessPartnerContact.prototype, "contactRelationship", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ContactRelationshipAddressLines,
        isMutable: true,
    })
], BusinessPartnerContact.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTMOB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipCellPhone", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipCity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], BusinessPartnerContact.prototype, "relationshipCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTBIR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BusinessPartnerContact.prototype, "relationshipDateOfBirth", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTEMA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipEmail", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFAX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipFax", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipFirstName", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFULNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipFullNameSearchKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTFBDMAG',
    })
], BusinessPartnerContact.prototype, "relationshipIsMailingProhibited", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTETS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipLandline", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTLAN',
        columnType: 'string',
        node: () => sageX3System.nodes.Language,
    })
], BusinessPartnerContact.prototype, "relationshipLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CNTLNA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipLastName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTCSP',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], BusinessPartnerContact.prototype, "relationshipProfessionalCategory", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipState", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTTL',
        dataType: () => sageX3System.enums.titleDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipTitle", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CNTTYP',
        dataType: () => sageX3System.enums.contactTypeDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZIP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BusinessPartnerContact.prototype, "relationshipZipCode", void 0);
exports.BusinessPartnerContact = BusinessPartnerContact = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CONTACT',
        keyPropertyNames: ['entityType', 'businessPartner', 'code'],
        indexes: [
            {
                orderBy: {
                    entityType: 1,
                    businessPartner: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['entityType', 'businessPartner'],
        }),
        getFilters() {
            return [{ entityType: 'businessPartner' }];
        },
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BusinessPartnerContact);
//# sourceMappingURL=business-partner-contact.js.map