"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BusinessPartnerCompanyException = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        businessPartner: {
            code: 'businessPartner',
        },
        company: {
            code: 'company',
        },
        mappingCode: {
            code: 'mappingCode',
        },
    },
};
let BusinessPartnerCompanyException = class BusinessPartnerCompanyException extends xtrem_core_1.Node {
};
exports.BusinessPartnerCompanyException = BusinessPartnerCompanyException;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], BusinessPartnerCompanyException.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], BusinessPartnerCompanyException.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ACEAUZ',
    })
], BusinessPartnerCompanyException.prototype, "isAuthorizedEntry", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PAYDAY',
        serviceOptions: () => [sageX3System.serviceOptions.MaxpdActivityCode],
    })
], BusinessPartnerCompanyException.prototype, "contractualPeriod", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFOEXDCPY',
        serviceOptions: () => [sageX3System.serviceOptions.CfomActivityCode],
    })
], BusinessPartnerCompanyException.prototype, "isCashExcluded", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EINVTYP',
        dataType: () => sageX3MasterData.enums.electronicInvoiceTypeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartnerCompanyException.prototype, "electronicInvoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAPCODBPC',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Mapping,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], BusinessPartnerCompanyException.prototype, "mappingCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REGAGR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KspActivityCode],
    })
], BusinessPartnerCompanyException.prototype, "registrationAgreement", void 0);
exports.BusinessPartnerCompanyException = BusinessPartnerCompanyException = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BPEXCEPT',
        keyPropertyNames: ['businessPartner', 'company'],
        indexes: [
            {
                orderBy: {
                    businessPartner: 1,
                    company: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.MulActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BusinessPartnerCompanyException);
//# sourceMappingURL=business-partner-company-exception.js.map