"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BomProduct = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        product: {
            code: 'product',
        },
    },
};
let BomProduct = class BomProduct extends xtrem_core_1.Node {
};
exports.BomProduct = BomProduct;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], BomProduct.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALT',
    })
], BomProduct.prototype, "bomCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LLCTYP',
        dataType: () => sageX3MasterData.enums.lowLevelTypeDatatype,
    })
], BomProduct.prototype, "lowestLevelCodeType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LLC',
    })
], BomProduct.prototype, "lowestLevelCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMEXIFLG',
    })
], BomProduct.prototype, "isBomExistence", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WUSEXIFLG',
    })
], BomProduct.prototype, "isWhereUsedExistence", void 0);
exports.BomProduct = BomProduct = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITMBOM',
        keyPropertyNames: ['product', 'bomCode', 'lowestLevelCodeType'],
        indexes: [
            {
                orderBy: {
                    product: 1,
                    bomCode: 1,
                    lowestLevelCodeType: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['bomCode'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BomProduct);
//# sourceMappingURL=bom-product.js.map