"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BomHeader = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    referenceJoins: {
        parentProduct: {
            code: 'parentProduct',
        },
        bomCode: {
            bomType: 'bomType',
            code: 'bomCode',
        },
        accessCode: {
            access: 'accessCode',
        },
    },
    localizedStrings: {
        description: {
            tableName() {
                return 'BOM';
            },
            columnName() {
                return 'BOMDESAXX';
            },
            key1: ['parentProduct', 'bomCode'],
            key2: ['bomType'],
        },
    },
    collectionJoins: {
        details: {
            bomCode: 'bomCode',
            parentProduct: 'parentProduct',
            bomType: 'bomType',
        },
    },
};
let BomHeader = class BomHeader extends xtrem_core_1.Node {
};
exports.BomHeader = BomHeader;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], BomHeader.prototype, "parentProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMALT',
        columnType: 'integer',
        node: () => sageX3MasterData.nodes.BomCodes,
    })
], BomHeader.prototype, "bomCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMALTTYP',
        dataType: () => sageX3MasterData.enums.bomCodeTypeDatatype,
    })
], BomHeader.prototype, "bomType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], BomHeader.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'USESTA',
        dataType: () => sageX3MasterData.enums.useStatusDatatype,
    })
], BomHeader.prototype, "useStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NPIPRO',
        serviceOptions: () => [sageX3System.serviceOptions.NpiActivityCode],
    })
], BomHeader.prototype, "isPrototype", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOHSTRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BomHeader.prototype, "validityStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOHENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BomHeader.prototype, "validityEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMRLE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomHeader.prototype, "reviewLevel", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BomHeader.prototype, "baseQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYCOD',
        dataType: () => sageX3MasterData.enums.managementUnitDatatype,
    })
], BomHeader.prototype, "managementUnit", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HEATEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomHeader.prototype, "headerText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CFGVCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.CfgActivityCode],
    })
], BomHeader.prototype, "journalNumberConfig", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACSCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], BomHeader.prototype, "accessCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLMATTURL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BomHeader.prototype, "linkedDocuments", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.BomDetail,
        isMutable: true,
        dependsOn: ['bomCode', 'parentProduct', 'bomType'],
    })
], BomHeader.prototype, "details", void 0);
exports.BomHeader = BomHeader = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BOM',
        keyPropertyNames: ['parentProduct', 'bomCode', 'bomType'],
        indexes: [
            {
                orderBy: {
                    parentProduct: 1,
                    bomCode: 1,
                    bomType: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['bomType'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BomHeader);
//# sourceMappingURL=bom-header.js.map