import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageX3MasterData from '..';
export declare class BomDetail extends Node {
    readonly parentProduct: Reference<sageX3MasterData.nodes.Product>;
    readonly bomCode: Reference<sageX3MasterData.nodes.BomHeader>;
    readonly sequence: Promise<integer>;
    readonly componentProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly bomType: Promise<sageX3MasterData.enums.BomCodeType>;
    readonly sequenceRemainder: Promise<integer | null>;
    readonly componentType: Promise<sageX3MasterData.enums.ComponentType | null>;
    readonly linkDescription: Promise<string>;
    readonly firstValidLot: Promise<string>;
    readonly lastValidLot: Promise<string>;
    readonly validityStartDate: Promise<date | null>;
    readonly validityEndDate: Promise<date | null>;
    readonly linkQuantityCode: Promise<sageX3MasterData.enums.BomQuantityLink | null>;
    readonly quantityRounding: Promise<sageX3MasterData.enums.ComponentRounded | null>;
    readonly uom: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly uomStockFactor: Promise<decimal | null>;
    readonly uomLinkQuantity: Promise<decimal | null>;
    readonly linkQuantity: Promise<decimal | null>;
    readonly scrapFactorPercentage: Promise<decimal | null>;
    readonly routingOperation: Promise<integer | null>;
    readonly routingOperationSuffix: Promise<integer | null>;
    readonly operationLeadTime: Promise<integer | null>;
    readonly isPrintMaterialNote: Promise<boolean>;
    readonly isPrintAcknowledgment: Promise<boolean>;
    readonly isPrintPackingSlip: Promise<boolean>;
    readonly isPrintInvoice: Promise<boolean>;
    readonly linkReviewIndex: Promise<string>;
    readonly isValuation: Promise<boolean>;
    readonly pickListCode: Promise<sageX3MasterData.enums.CodeToServe | null>;
    readonly weighingPositiveTolerancePercentage: Promise<decimal | null>;
    readonly weighingNegativeTolerancePercentage: Promise<decimal | null>;
    readonly setupLevel: Promise<sageX3MasterData.enums.ToleranceDefinitionLevel | null>;
    readonly typeOfSupply: Promise<sageX3MasterData.enums.MaterialReplenishType | null>;
    readonly selectionFormula: Promise<string>;
    readonly quantityFormula: Promise<string>;
    readonly majorVersion: Promise<string>;
    readonly minorVersion: Promise<string>;
    readonly revisionGroup: Promise<integer | null>;
    readonly masterContainer: Promise<string>;
}
//# sourceMappingURL=bom-detail.d.ts.map