"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompanyExtension = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3MasterData = require("..");
const joins = {
    collectionJoins: {
        addresses: {
            entityType() {
                return 'company';
            },
            company: 'code',
        },
        contacts: {
            entityType() {
                return 'company';
            },
            company: 'code',
        },
        bankDetails: {
            entityType() {
                return 'company';
            },
            company: 'code',
        },
    },
};
let CompanyExtension = class CompanyExtension extends xtrem_core_1.NodeExtension {
};
exports.CompanyExtension = CompanyExtension;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SERVICEID',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EinvActivityCode],
    })
], CompanyExtension.prototype, "serviceId", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.CompanyAddress,
        isMutable: true,
        dependsOn: ['code'],
    })
], CompanyExtension.prototype, "addresses", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.CompanyContact,
        isMutable: true,
        dependsOn: ['code'],
    })
], CompanyExtension.prototype, "contacts", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.CompanyBankDetail,
        isMutable: true,
        dependsOn: ['code'],
    })
], CompanyExtension.prototype, "bankDetails", void 0);
exports.CompanyExtension = CompanyExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3System.nodes.Company,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], CompanyExtension);
//# sourceMappingURL=company-extension.js.map