/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.handler=exports.builder=exports.desc=exports.command=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),start_1=require("./handlers/start");exports.command=["start","s"],exports.desc="Start an xtrem application";const builder=e=>(0,xtrem_cli_lib_1.pluggableBuilder)(exports.command,e.version(false).option("channels",{desc:"Comma separated list of channels to be active on the server. The allowed channels are:\n'routing':      Starts the communication routing services.\n'listeners':    Starts the communication listeners.\n'graphql':      Starts the server in interactive mode. Endpoints are active by default. If the --channels option is not supplied, then all the channels are active by default.",type:"array",default:xtrem_core_1.allowedStartChannels,choices:xtrem_core_1.allowedStartChannels,coerce:e=>{let t=[];return e.forEach(e=>{t=[...t,...e.split(",")]}),t}}).option("services",{desc:"Comma separated list of packages to be started as a service. If the --services option is ommitted the start command loads all the packages and run all their startService methods. This allows to easily start all services in development mode",type:"string"}).option("web-sockets",{desc:"TBD",type:"string"}).option("cluster",{desc:"Cluster mode. Creates a forked process given the config cluster.numberOfForkedProcesses, if numberOfForkedProcesses is not provided then a fork is created for each available CPU",type:"boolean"}).option("config-extension-location",{desc:"Location on the file system where extensions to the config can be found.",type:"string"}).option("references",{desc:"TBD",type:"boolean"}).option("queues",{desc:"Comma separated list of queues to explicitly start",type:"string",default:void 0,coerce:e=>{if(null==e)return e;return e.split(",").filter(e=>e)}}).middleware(e=>(e.isUsingReferences=e.references,e)).example("$0 start","Start all services and channels"));exports.builder=builder;const handler=e=>(async()=>{const t=e,r=(0,start_1.createStartContext)(t);if((await(0,xtrem_cli_lib_1.pluggableHandler)(exports.command,e,r)).skipDefault)return void(0,xtrem_cli_lib_1.printWarning)(xtrem_cli_lib_1.cliContext.executionMode,"skip default main start");if(!r)throw new xtrem_core_1.SystemError("Failed to create start context");await(0,start_1.start)(r)})();exports.handler=handler;
//# sourceMappingURL=start.js.map