/// <reference types="node" />
/// <reference types="node" />
import { Dict } from '@sage/xtrem-core';
import { Cluster, Worker } from 'cluster';
export declare class XtremWorker {
    #private;
    readonly initWorkerId: string;
    readonly cluster: Cluster;
    requestKeys: string[];
    promise: Promise<void>;
    /**
     *
     * @param workerId the identifier of the worker
     * @param cluster the cluster instance used to manage(fork/spawn) a worker
     */
    constructor(initWorkerId: string, cluster: Cluster);
    get workerId(): string;
    set workerId(workerId: string);
    init(): this;
    /**
     * reset the current worker instance with newly forked one.
     */
    fork(requestKey?: string): void;
    /**
     * The current Worker instance that is alive
     */
    get worker(): Worker;
    /**
     * The index of the worker in the cluster instance workers dictionary
     */
    get index(): number;
    /**
     * Is the worker ready to use, this set when the worker process sends a message back to the main process with the port
     */
    get isReady(): boolean;
    /**
     * Is the worker set and is the worker alive
     */
    get workerExists(): boolean;
    /**
     * Port of the current worker
     */
    get port(): number;
    static workers: Dict<XtremWorker[]>;
    static counters: Dict<number>;
    /**
     * Add a worker to the workers list
     * @param cluster
     * @param startIndex
     * @param stopIndex
     */
    static addWorkers(cluster: Cluster, requestSource: string, startIndex: number, stopIndex: number): void;
    /**
     * Seed a worker for the request source, if the worker pool does not have enough workers
     * @param cluster
     * @param requestSource
     * @param maxWorkers
     */
    static seedWorker(cluster: Cluster, requestSource: string, maxWorkers?: number): void;
    static defaultSeedInterval: NodeJS.Timeout;
    static deferredWorkerTimeout: Dict<NodeJS.Timeout>;
    static seeded: boolean;
    /**
     * Spawn workers for the known sources as far as possible
     * @param cluster
     */
    static seedWorkers(cluster: Cluster): void;
    /**
     * Fill the request source worker list with workers from the default worker list, only if the default source has workers available
     * and the request source does not have enough workers
     * @param requestSource
     * @param maxWorkers
     */
    static fillFromDefaultWorkers(requestSource: string, maxWorkers: number): void;
    /**
     * Initialize the list of workers
     * @param cluster
     * @param maxWorkers
     */
    static initializeWorkers(cluster: Cluster, requestSource: string, maxWorkers: number): void;
    /**
     * sleep for the supplied number of ms
     */
    static sleep(ms: number): Promise<void>;
    private static fillRequestSource;
    /**
     * Get the next worker that is ready from the workers list
     * @param cluster
     * @param requestSource
     * @param count
     * @returns
     */
    static getNextWorker(cluster: Cluster, requestSource: string, requestKey: string): Promise<XtremWorker | undefined>;
}
//# sourceMappingURL=worker.d.ts.map