import { Application, StartChannel } from '@sage/xtrem-core';
export interface StartServicesOptions {
    channels: StartChannel[];
    services?: string;
    webSockets?: string[];
    configExtensionLocation?: string;
    /**
     * Names of queues to explicitly start
     * If not set, all the queues will be started
     */
    queues?: string[];
}
/**
 * Start a service for the current process
 * @param dir
 * @param options
 * @returns
 */
export declare const startWorkerServices: (application: Application) => Promise<void>;
/**
 * Manage the start command, if multi-worker service are enabled then start the proxy service, otherwise start a single process as normal
 * @param dir
 * @param options
 * @returns
 */
export declare const startServices: (dir: string, options: StartServicesOptions) => Promise<void>;
//# sourceMappingURL=start-server.d.ts.map