// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/index.d.ts
declare module '@sage/xtrem-app-metadata/index' {
	export * from '@sage/xtrem-app-metadata/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/index.d.ts
declare module '@sage/xtrem-app-metadata/lib/index' {
	import * as services from '@sage/xtrem-app-metadata/lib/services/_index';
	export * as dataTypes from '@sage/xtrem-app-metadata/lib/data-types/_index';
	export * as enums from '@sage/xtrem-app-metadata/lib/enums/_index';
	export * as interfaces from '@sage/xtrem-app-metadata/lib/interfaces/_index';
	export * as nodes from '@sage/xtrem-app-metadata/lib/nodes/_index';
	export { services };
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/services/metadata-storage-manager.d.ts
declare module '@sage/xtrem-app-metadata/lib/services/metadata-storage-manager' {
	import { AnyRecord, AnyRecordWithId, AnyValue, AsyncReader, Context, Dict, Extend, ExternalStorageManager, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, Property, PropertyAndValue, ValidationContext } from '@sage/xtrem-core';
	import { MetaArtifacts } from '@sage/xtrem-app-metadata/lib/services/metadata-interfaces';
	enum StorageStatus {
	    notStarted = 0,
	    done = 1,
	    reload = 2
	}
	export class MetadataStorageManager<T extends Node> implements ExternalStorageManager<T> {
	    factory: NodeFactory;
	    private readonly logger;
	    private notAllowedError;
	    private get naturalKey();
	    insert(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecordWithId>;
	    update(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecord[]>;
	    delete(_node: Extend<T>, _cx: ValidationContext): Promise<number>;
	    static getRecordValue(factory: NodeFactory, _id: string): MetaArtifacts | undefined;
	    static getPropertyValue(context: Context, property: Property, value: AnyRecord): AnyValue;
	    query(context: Context, options: NodeExternalQueryOptions<T>): AsyncReader<any>;
	    mapRecordIn(record: any): any;
	    mapAggregateRecordIn(_record: any): any;
	    getReferenceJoin(propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
	    getCollectionJoin(propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
	    getJoinValues(_node: Extend<T>, data: any, propertyName: string): Dict<any>;
	    private getPropertyFromPath;
	    private convertOrderBy;
	    parseOrderBy(_context: Context, orderBy: OrderBy<Node> | undefined): OrderByClause[];
	    private static safeParseInt;
	    private static safeParseFloat;
	    private static parsePropertyValue;
	    private static fastHash;
	    private static removeCursorChecksum;
	    private static parseCursorValues;
	    parseCursor(orderByClauses: OrderByClause[], value: string): PropertyAndValue[];
	    private _lastTransientId;
	    allocateTransientId(): string;
	    /**
	     * Get the transient value for the specific type of the property passed
	     * @param context
	     * @param propertyName
	     * @returns
	     */
	    private getTransientValue;
	    getKeyValues(context: Context, values: any, options?: {
	        allocateTransient: boolean;
	    }): Dict<any>;
	    isKeyPropertyTransient(_propertyName: string, _value: any): boolean;
	    isReverseReferenceProperty(_propertyName: string): boolean;
	    get defaultOrderBy(): OrderBy<Node>;
	    /**
	     * Gets the formatted key values a string concatenated by `~`
	     * This will be used for the _id value
	     *
	     * @param context
	     * @param values
	     * @returns
	     */
	    getId(_context: Context, values: Dict<any>): string;
	    canCreate(_canCreate: boolean): boolean;
	    canUpdate(_canUpdate: boolean): boolean;
	    canDelete(_canDelete: boolean): boolean;
	    canDeleteMany(_canDeleteMany: boolean): boolean;
	    private static readonly ensureItemsCachedFunnel;
	    static progress: StorageStatus;
	    static invalidateCache(): void;
	    private static ensureItemsCached;
	}
	export {};
	//# sourceMappingURL=metadata-storage-manager.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/services/metadata-interfaces.d.ts
declare module '@sage/xtrem-app-metadata/lib/services/metadata-interfaces' {
	import { DecimalDataTypeOptions, EnumDataTypeOptions, FriendlyParameter, JsonDataTypeOptions, Node, OperationReturn, PlainParameter, ReferenceDataTypeOptions, StreamDataTypeOptions, StringDataTypeOptions } from '@sage/xtrem-core';
	import { AnyValue } from '@sage/xtrem-shared';
	import { MetaOperationAction } from '@sage/xtrem-app-metadata/lib/enums/meta-operation-action';
	import { MetaOperationKind } from '@sage/xtrem-app-metadata/lib/enums/meta-operation-kind';
	import { MetaPropertyType } from '@sage/xtrem-app-metadata/lib/enums/meta-property-type';
	import { MetaStorage } from '@sage/xtrem-app-metadata/lib/enums/meta-storage';
	export interface MetaPackage {
	    _id: string;
	    name: string;
	    title: AnyValue;
	}
	export type DataTypeAttributes = (StringDataTypeOptions | DecimalDataTypeOptions | JsonDataTypeOptions | StreamDataTypeOptions | EnumDataTypeOptions | ReferenceDataTypeOptions<Node, Node>) | null;
	export interface MetaServiceOption {
	    _id: string;
	    name: string;
	    title: AnyValue;
	    package: string;
	    isSubscribable: boolean;
	    isHidden: boolean;
	}
	export interface MetaDataType {
	    _id: string;
	    definingPackage: string;
	    name: string;
	    title: AnyValue;
	    type: MetaPropertyType;
	    attributes: DataTypeAttributes | null;
	    serviceOptionNames: string[] | null;
	}
	export interface MetaNodeFactory {
	    _id: string;
	    name: string;
	    title: AnyValue;
	    package: string;
	    isPublished: boolean;
	    isAbstract: boolean;
	    extends: string | null;
	    storage: MetaStorage;
	    isSharedByAllTenants: boolean;
	    isSetupNode: boolean;
	    isPlatformNode: boolean;
	    isVitalReferenceChild: boolean;
	    isVitalCollectionChild: boolean;
	    isCustomizable: boolean;
	    isSynchronizable: boolean;
	    isSynchronized: boolean;
	    serviceOptionNames: string[] | null;
	    properties: string[];
	    operations: string[];
	    isCached: boolean;
	    naturalKey: string[] | null;
	}
	export interface MetaNodeProperty {
	    _id: string;
	    factory: string;
	    name: string;
	    title: AnyValue;
	    package: string;
	    serviceOptionNames: string[] | null;
	    type: MetaPropertyType;
	    dataType?: string;
	    dependencyIndex: number;
	    isPublished: boolean;
	    isStored: boolean;
	    isTransientInput: boolean;
	    isStoredOutput: boolean;
	    isRequired: boolean;
	    isNullable: boolean;
	    targetFactory: string | null;
	    reverseReference: string | null;
	    isVital: boolean;
	    isVitalParent: boolean;
	    isInherited: boolean;
	    canSort: boolean;
	    canFilter: boolean;
	    isOnInputType: boolean;
	    isOnOutputType: boolean;
	    isMutable: boolean;
	}
	export interface MetaNodeOperation {
	    _id: string;
	    factory: string;
	    name: string;
	    title: AnyValue;
	    package: string;
	    serviceOptionNames: string[] | null;
	    kind: MetaOperationKind;
	    action: MetaOperationAction | null;
	    isPublished: boolean;
	    isSchedulable: boolean;
	    isMutation: boolean;
	    parameters: PlainParameter[];
	    return: OperationReturn<typeof Node, any>;
	    signature: {
	        parameters: FriendlyParameter[];
	        return: FriendlyParameter;
	    };
	    topic: string;
	}
	export type MetaArtifacts = MetaPackage | MetaServiceOption | MetaDataType | MetaNodeFactory | MetaNodeProperty | MetaNodeOperation;
	//# sourceMappingURL=metadata-interfaces.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/services/metadata-helper.d.ts
declare module '@sage/xtrem-app-metadata/lib/services/metadata-helper' {
	import { Context, Dict, NodeFactory } from '@sage/xtrem-core';
	import { MetaArtifacts, MetaDataType, MetaNodeFactory, MetaNodeOperation, MetaNodeProperty, MetaPackage, MetaServiceOption } from '@sage/xtrem-app-metadata/lib/services/metadata-interfaces';
	export class MetadataHelper {
	    private static getLocalizedTitles;
	    static dataByNode: Dict<MetaArtifacts[]>;
	    static packages: Dict<MetaPackage>;
	    static loadPackages(context: Context): Promise<void>;
	    static serviceOptions: Dict<MetaServiceOption>;
	    static loadServiceOptions(context: Context): void;
	    static dataTypes: Dict<MetaDataType>;
	    static loadDatatypes(context: Context): void;
	    static factories: Dict<MetaNodeFactory>;
	    static properties: Dict<MetaNodeProperty>;
	    static operations: Dict<MetaNodeOperation>;
	    private static getOperationLocalizedTitleKey;
	    static loadNodeFactories(context: Context): void;
	    static getIsActiveValue(context: Context, factory: NodeFactory, value: MetaArtifacts): Promise<boolean | undefined>;
	    static loadMetadataStorage(context: Context): Promise<void>;
	}
	//# sourceMappingURL=metadata-helper.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/services/_index.d.ts
declare module '@sage/xtrem-app-metadata/lib/services/_index' {
	export * from '@sage/xtrem-app-metadata/lib/services/metadata-storage-manager';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/meta-service-option.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/meta-service-option' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as xtremAppMetadata from '@sage/xtrem-app-metadata/lib/index';
	export class MetaServiceOption extends Node {
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly package: Reference<xtremAppMetadata.nodes.MetaPackage>;
	    readonly isSubscribable: Promise<boolean>;
	    readonly isActive: Promise<boolean>;
	    readonly isHidden: Promise<boolean>;
	}
	//# sourceMappingURL=meta-service-option.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/meta-package.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/meta-package' {
	import { Node } from '@sage/xtrem-core';
	export class MetaPackage extends Node {
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=meta-package.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/meta-node-property.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/meta-node-property' {
	import { Dict, integer, Node, Reference } from '@sage/xtrem-core';
	import * as xtremAppMetadata from '@sage/xtrem-app-metadata/lib/index';
	import { MetaDataType } from '@sage/xtrem-app-metadata/lib/nodes/meta-data-type';
	export class MetaNodeProperty extends Node {
	    readonly factory: Reference<xtremAppMetadata.nodes.MetaNodeFactory>;
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly package: Reference<xtremAppMetadata.nodes.MetaPackage>;
	    readonly serviceOptionNames: Promise<Dict<string>>;
	    readonly serviceOptions: Promise<xtremAppMetadata.nodes.MetaServiceOption[]>;
	    readonly isActive: Promise<boolean>;
	    readonly type: Promise<xtremAppMetadata.enums.MetaPropertyType>;
	    readonly dataType: Reference<MetaDataType>;
	    readonly dependencyIndex: Promise<integer>;
	    readonly isPublished: Promise<boolean>;
	    readonly isStored: Promise<boolean>;
	    readonly isTransientInput: Promise<boolean>;
	    readonly isStoredOutput: Promise<boolean>;
	    readonly isRequired: Promise<boolean>;
	    readonly isNullable: Promise<boolean>;
	    readonly targetFactory: Reference<xtremAppMetadata.nodes.MetaNodeFactory | null>;
	    readonly reverseReference: Reference<MetaNodeProperty | null>;
	    readonly isVital: Promise<boolean>;
	    readonly isVitalParent: Promise<boolean>;
	    readonly isInherited: Promise<boolean>;
	    readonly canSort: Promise<boolean>;
	    readonly canFilter: Promise<boolean>;
	    readonly isOnInputType: Promise<boolean>;
	    readonly isOnOutputType: Promise<boolean>;
	    readonly isMutable: Promise<boolean>;
	}
	//# sourceMappingURL=meta-node-property.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/meta-node-operation.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/meta-node-operation' {
	import { Node, PlainParameter, Reference } from '@sage/xtrem-core';
	import * as xtremAppMetadata from '@sage/xtrem-app-metadata/lib/index';
	export class MetaNodeOperation extends Node {
	    readonly factory: Reference<xtremAppMetadata.nodes.MetaNodeFactory>;
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly package: Reference<xtremAppMetadata.nodes.MetaPackage>;
	    readonly serviceOptionNames: Promise<string[]>;
	    readonly serviceOptions: Promise<xtremAppMetadata.nodes.MetaServiceOption[]>;
	    readonly isActive: Promise<boolean>;
	    readonly kind: Promise<xtremAppMetadata.enums.MetaOperationKind>;
	    readonly action: Promise<xtremAppMetadata.enums.MetaOperationAction | null>;
	    readonly isPublished: Promise<boolean>;
	    readonly isSchedulable: Promise<boolean>;
	    readonly isMutation: Promise<boolean>;
	    readonly parameters: Promise<PlainParameter[]>;
	    readonly return: Promise<object>;
	    readonly signature: Promise<{
	        parameters: PlainParameter[];
	        return: object;
	    }>;
	    readonly topic: Promise<string>;
	}
	//# sourceMappingURL=meta-node-operation.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/meta-node-factory.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/meta-node-factory' {
	import { Collection, Dict, Node, Reference } from '@sage/xtrem-core';
	import { MetaCustomField } from '@sage/xtrem-shared';
	import * as xtremAppMetadata from '@sage/xtrem-app-metadata/lib/index';
	export class MetaNodeFactory extends Node {
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly package: Reference<xtremAppMetadata.nodes.MetaPackage>;
	    readonly isActive: Promise<boolean>;
	    readonly isPublished: Promise<boolean>;
	    readonly isAbstract: Promise<boolean>;
	    readonly extends: Reference<MetaNodeFactory | null>;
	    readonly storage: Promise<xtremAppMetadata.enums.MetaStorage>;
	    readonly isSharedByAllTenants: Promise<boolean>;
	    readonly isSetupNode: Promise<boolean>;
	    readonly isPlatformNode: Promise<boolean>;
	    readonly isVitalReferenceChild: Promise<boolean>;
	    readonly isVitalCollectionChild: Promise<boolean>;
	    readonly isCustomizable: Promise<boolean>;
	    readonly isSynchronizable: Promise<boolean>;
	    readonly isSynchronized: Promise<boolean>;
	    readonly serviceOptionNames: Promise<Dict<string>>;
	    readonly serviceOptions: Promise<xtremAppMetadata.nodes.MetaServiceOption[] | null>;
	    readonly naturalKey: Promise<string[] | null>;
	    readonly customFields: Promise<MetaCustomField[]>;
	    readonly properties: Collection<xtremAppMetadata.nodes.MetaNodeProperty>;
	    readonly operations: Collection<xtremAppMetadata.nodes.MetaNodeOperation>;
	    getNode(): Promise<typeof Node>;
	}
	//# sourceMappingURL=meta-node-factory.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/meta-data-type.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/meta-data-type' {
	import { Dict, Node, Reference } from '@sage/xtrem-core';
	import * as xtremAppMetadata from '@sage/xtrem-app-metadata/lib/index';
	import { DataTypeAttributes } from '@sage/xtrem-app-metadata/lib/services/metadata-interfaces';
	export class MetaDataType extends Node {
	    readonly definingPackage: Reference<xtremAppMetadata.nodes.MetaPackage>;
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly type: Promise<xtremAppMetadata.enums.MetaPropertyType>;
	    readonly attributes: Promise<DataTypeAttributes | null>;
	    readonly serviceOptionNames: Promise<Dict<string> | null>;
	    readonly serviceOptions: Promise<xtremAppMetadata.nodes.MetaServiceOption[] | null>;
	    readonly isActive: Promise<boolean>;
	}
	//# sourceMappingURL=meta-data-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/nodes/_index.d.ts
declare module '@sage/xtrem-app-metadata/lib/nodes/_index' {
	export * from '@sage/xtrem-app-metadata/lib/nodes/meta-data-type';
	export * from '@sage/xtrem-app-metadata/lib/nodes/meta-node-factory';
	export * from '@sage/xtrem-app-metadata/lib/nodes/meta-node-operation';
	export * from '@sage/xtrem-app-metadata/lib/nodes/meta-node-property';
	export * from '@sage/xtrem-app-metadata/lib/nodes/meta-package';
	export * from '@sage/xtrem-app-metadata/lib/nodes/meta-service-option';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/interfaces/parameter-node.d.ts
declare module '@sage/xtrem-app-metadata/lib/interfaces/parameter-node' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as xtremMetadata from '@sage/xtrem-app-metadata/lib/index';
	export interface ParameterNode extends Node {
	    readonly name: Promise<string>;
	    readonly title: Promise<string>;
	    readonly type: Promise<xtremMetadata.enums.MetaPropertyType>;
	    readonly dataType: Reference<xtremMetadata.nodes.MetaDataType>;
	}
	//# sourceMappingURL=parameter-node.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/interfaces/_index.d.ts
declare module '@sage/xtrem-app-metadata/lib/interfaces/_index' {
	export * from '@sage/xtrem-app-metadata/lib/interfaces/parameter-node';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/enums/meta-storage.d.ts
declare module '@sage/xtrem-app-metadata/lib/enums/meta-storage' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum MetaStorageEnum {
	    sql = 1,
	    json = 2,
	    external = 3
	}
	export type MetaStorage = keyof typeof MetaStorageEnum;
	export const storageDataType: EnumDataType<"json" | "sql" | "external", unknown>;
	//# sourceMappingURL=meta-storage.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/enums/meta-property-type.d.ts
declare module '@sage/xtrem-app-metadata/lib/enums/meta-property-type' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum MetaPropertyTypeEnum {
	    boolean = 1,
	    string = 2,
	    byte = 3,
	    short = 4,
	    integer = 5,
	    decimal = 5,
	    float = 7,
	    double = 8,
	    enum = 9,
	    date = 10,
	    time = 11,
	    datetime = 12,
	    uuid = 13,
	    binaryStream = 14,
	    textStream = 15,
	    json = 16,
	    reference = 17,
	    collection = 18,
	    jsonReference = 19,
	    integerArray = 20,
	    enumArray = 21,
	    referenceArray = 22,
	    stringArray = 23,
	    integerRange = 24,
	    decimalRange = 25,
	    dateRange = 26,
	    datetimeRange = 27,
	    binary = 27
	}
	export type MetaPropertyType = keyof typeof MetaPropertyTypeEnum;
	export const MetaPropertyTypeDataType: EnumDataType<"string" | "boolean" | "byte" | "short" | "integer" | "decimal" | "float" | "double" | "enum" | "date" | "time" | "datetime" | "uuid" | "binaryStream" | "textStream" | "json" | "reference" | "collection" | "jsonReference" | "integerArray" | "enumArray" | "referenceArray" | "stringArray" | "integerRange" | "decimalRange" | "dateRange" | "datetimeRange" | "binary", unknown>;
	//# sourceMappingURL=meta-property-type.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/enums/meta-operation-kind.d.ts
declare module '@sage/xtrem-app-metadata/lib/enums/meta-operation-kind' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum MetaOperationKindEnum {
	    query = 1,
	    mutation = 2,
	    asyncMutation = 3,
	    asyncTrackerQuery = 4,
	    bulkMutation = 5
	}
	export type MetaOperationKind = keyof typeof MetaOperationKindEnum;
	export const operationKindDataType: EnumDataType<"query" | "mutation" | "asyncMutation" | "asyncTrackerQuery" | "bulkMutation", unknown>;
	//# sourceMappingURL=meta-operation-kind.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/enums/meta-operation-action.d.ts
declare module '@sage/xtrem-app-metadata/lib/enums/meta-operation-action' {
	import { EnumDataType } from '@sage/xtrem-core';
	export enum MetaOperationActionEnum {
	    start = 1,
	    stop = 2,
	    track = 3
	}
	export type MetaOperationAction = keyof typeof MetaOperationActionEnum;
	export const operationActionDataType: EnumDataType<"start" | "stop" | "track", unknown>;
	//# sourceMappingURL=meta-operation-action.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/enums/_index.d.ts
declare module '@sage/xtrem-app-metadata/lib/enums/_index' {
	export * from '@sage/xtrem-app-metadata/lib/enums/meta-operation-action';
	export * from '@sage/xtrem-app-metadata/lib/enums/meta-operation-kind';
	export * from '@sage/xtrem-app-metadata/lib/enums/meta-property-type';
	export * from '@sage/xtrem-app-metadata/lib/enums/meta-storage';
	//# sourceMappingURL=_index.d.ts.map
}
// From file: /agent/_work/1/s/platform/system/xtrem-app-metadata/build/lib/data-types/_index.d.ts
declare module '@sage/xtrem-app-metadata/lib/data-types/_index' {
	import { StringDataType } from '@sage/xtrem-core';
	export const metadataName: StringDataType<unknown, string>;
	export const metadataTitle: StringDataType<unknown, string>;
	//# sourceMappingURL=_index.d.ts.map
}
declare module '@sage/xtrem-app-metadata' {
	export * from '@sage/xtrem-app-metadata/index';
}
