import { AnyRecord, AnyRecordWithId, AnyValue, AsyncReader, Context, Dict, Extend, ExternalStorageManager, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, Property, PropertyAndValue, ValidationContext } from '@sage/xtrem-core';
import { MetaArtifacts } from './metadata-interfaces';
declare enum StorageStatus {
    notStarted = 0,
    done = 1,
    reload = 2
}
export declare class MetadataStorageManager<T extends Node> implements ExternalStorageManager<T> {
    factory: NodeFactory;
    private readonly logger;
    private notAllowedError;
    private get naturalKey();
    insert(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecordWithId>;
    update(_node: Extend<T>, _cx: ValidationContext): Promise<AnyRecord[]>;
    delete(_node: Extend<T>, _cx: ValidationContext): Promise<number>;
    static getRecordValue(factory: NodeFactory, _id: string): MetaArtifacts | undefined;
    static getPropertyValue(context: Context, property: Property, value: AnyRecord): AnyValue;
    query(context: Context, options: NodeExternalQueryOptions<T>): AsyncReader<any>;
    mapRecordIn(record: any): any;
    mapAggregateRecordIn(_record: any): any;
    getReferenceJoin(propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
    getCollectionJoin(propertyName: string): Dict<string | ((this: Extend<T>) => any)>;
    getJoinValues(_node: Extend<T>, data: any, propertyName: string): Dict<any>;
    private getPropertyFromPath;
    private convertOrderBy;
    parseOrderBy(_context: Context, orderBy: OrderBy<Node> | undefined): OrderByClause[];
    private static safeParseInt;
    private static safeParseFloat;
    private static parsePropertyValue;
    private static fastHash;
    private static removeCursorChecksum;
    private static parseCursorValues;
    parseCursor(orderByClauses: OrderByClause[], value: string): PropertyAndValue[];
    private _lastTransientId;
    allocateTransientId(): string;
    /**
     * Get the transient value for the specific type of the property passed
     * @param context
     * @param propertyName
     * @returns
     */
    private getTransientValue;
    getKeyValues(context: Context, values: any, options?: {
        allocateTransient: boolean;
    }): Dict<any>;
    isKeyPropertyTransient(_propertyName: string, _value: any): boolean;
    isReverseReferenceProperty(_propertyName: string): boolean;
    get defaultOrderBy(): OrderBy<Node>;
    /**
     * Gets the formatted key values a string concatenated by `~`
     * This will be used for the _id value
     *
     * @param context
     * @param values
     * @returns
     */
    getId(_context: Context, values: Dict<any>): string;
    canCreate(_canCreate: boolean): boolean;
    canUpdate(_canUpdate: boolean): boolean;
    canDelete(_canDelete: boolean): boolean;
    canDeleteMany(_canDeleteMany: boolean): boolean;
    private static readonly ensureItemsCachedFunnel;
    static progress: StorageStatus;
    static invalidateCache(): void;
    private static ensureItemsCached;
}
export {};
//# sourceMappingURL=metadata-storage-manager.d.ts.map