/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MetadataHelper=void 0;const xtrem_decimal_1=require("@sage/xtrem-decimal"),typesLib=xtrem_decimal_1,xtrem_core_1=require("@sage/xtrem-core"),i18n=require("@sage/xtrem-i18n"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash");class MetadataHelper{static getLocalizedTitles(e,t){return _.zipObject(xtrem_shared_1.supportedLocales,xtrem_shared_1.supportedLocales.map(a=>{try{return(0,xtrem_i18n_1.localizedText)(e,t,{},a)}catch(e){return _.startCase(t)}}))}static{this.dataByNode={}}static async loadPackages(e){const t=await e.getActivePackageNames(),{application:a}=e;this.dataByNode.MetaPackage=[],this.packages=_.mapValues(a.packagesByName,e=>{const a={_id:e.name,name:e.name,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),e.name),isActive:t.includes(e.name)};return this.dataByNode.MetaPackage.push(a),a})}static loadServiceOptions(e){const{application:t}=e,a=t.serviceOptionsByName;this.dataByNode.MetaServiceOption=[],this.serviceOptions=_.mapValues(a,(e,t)=>{const a={...e,_id:t,name:t,package:e.packageName,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),t)};return this.dataByNode.MetaServiceOption.push(a),a})}static loadDatatypes(e){const{application:t}=e;this.dataByNode.MetaDataType=[],this.dataTypes=_.mapValues(t.dataTypes,(e,a)=>{const i=e.getMetaData({application:t,localize:(e,t)=>{const a=this.getLocalizedTitles(e,t);if(!a)return{base:t};return a}}),s={_id:a,definingPackage:e.pack||"",name:a,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),a),type:e.type,attributes:{...e?.dataTypeOptions?.(),...i},serviceOptionNames:e.serviceOptions?.map(e=>e.name)||null};return this.dataByNode.MetaDataType.push(s),s})}static getOperationLocalizedTitleKey(e,t){const a=t.definingPackage?.name||"";return i18n.getKey({isExtension:typesLib.strictNe(a,e.package.name),nodeName:e.name,packageName:a,operation:{name:t.name,kind:t.operationKind}})}static loadNodeFactories(e){const{application:t}=e,a=t.getAllFactories();this.dataByNode.MetaNodeFactory=[],this.dataByNode.MetaNodeProperty=[],this.dataByNode.MetaNodeOperation=[],this.factories={},this.properties={},this.operations={},a.forEach(e=>{const t=[...e.mutations,...e.queries];this.factories[e.name]={_id:e.name,name:e.name,title:this.getLocalizedTitles(e.getLocalizedTitleKey(),e.name),package:e.package.name,isPublished:e.isPublished,isAbstract:e.isAbstract,isCached:e.isCached,extends:null,storage:e.storage,isSharedByAllTenants:e.isSharedByAllTenants,isSetupNode:e.isSetupNode,isPlatformNode:e.isPlatformNode,isVitalReferenceChild:e.isVitalReferenceChild,isVitalCollectionChild:e.isVitalCollectionChild,isCustomizable:e.isCustomizable,isSynchronizable:e.isSynchronizable,isSynchronized:e.isSynchronized,serviceOptionNames:e.serviceOptions?.map(e=>e.name)||null,properties:e.properties.map(t=>`${e.name}|${t.name}`),operations:t.map(t=>`${e.name}|${t.name}`),naturalKey:e.naturalKey??null},this.dataByNode.MetaNodeFactory.push(this.factories[e.name]),e.properties.forEach(t=>{this.properties[`${e.name}|${t.name}`]={_id:`${e.name}|${t.name}`,factory:e.name,name:t.name,title:this.getLocalizedTitles(t.getLocalizedTitleKey(),t.name),package:t.definingPackage.name??e.package.name,serviceOptionNames:t.serviceOptions?.map(e=>e.name)||null,type:t.type,dataType:t.dataType?.name,dependencyIndex:t.dependencyIndex||-1,isPublished:t.isPublished,isStored:t.isStored,isTransientInput:t.isTransientInput,isStoredOutput:t.isStoredOutput,isRequired:t.isRequired,isNullable:t.isNullable,targetFactory:t.isForeignNodeProperty()?t.targetFactory.name:null,reverseReference:t.reverseReference??null,isVital:t.isVital,isVitalParent:t.isVitalParent,isInherited:t.isInherited,canSort:t.canSort,canFilter:t.canFilter,isOnInputType:t.isOnInputType,isOnOutputType:t.isOnOutputType,isMutable:t.isMutable},this.dataByNode.MetaNodeProperty.push(this.properties[`${e.name}|${t.name}`])}),t.forEach(t=>{this.operations[`${e.name}|${t.name}`]={_id:`${e.name}|${t.name}`,factory:e.name,name:t.name,title:this.getLocalizedTitles(this.getOperationLocalizedTitleKey(e,t),t.name),package:t.definingPackage?.name??e.package.name,serviceOptionNames:t.serviceOptions?.().map(e=>e.name)||null,kind:t.operationKind,action:t.action?t.action:null,isPublished:!!t.isPublished,isSchedulable:!!t.isSchedulable,isMutation:!!e.mutations.find(e=>typesLib.strictEq(e.name,t.name)),parameters:t.parameters,return:t.return,signature:(0,xtrem_core_1.friendlyOperationSignature)(t),topic:""},this.dataByNode.MetaNodeOperation.push(this.operations[`${e.name}|${t.name}`])})})}static async getIsActiveValue(e,t,a){if(typesLib.eq(t.propertiesByName.isActive,null))return;const{serviceOptionsByName:i}=e.application,isServiceOptionActive=t=>{const a=i[t];return a?e.isServiceOptionActiveSync(a):false};switch(t.name){case"MetaPackage":return(await e.getActivePackageNames()).includes(a.name);case"MetaServiceOption":return isServiceOptionActive(a.name);case"MetaDataType":case"MetaNodeFactory":case"MetaNodeProperty":case"MetaNodeOperation":{const e=a,{serviceOptionNames:t}=e;if(!t||typesLib.strictEq(t.length,0))return true;return Promise.resolve(t.every(isServiceOptionActive))}default:return}}static async loadMetadataStorage(e){await this.loadPackages(e),this.loadServiceOptions(e),this.loadDatatypes(e),this.loadNodeFactories(e)}}exports.MetadataHelper=MetadataHelper;
//# sourceMappingURL=metadata-helper.js.map