import { Dict, integer, Node, Reference } from '@sage/xtrem-core';
import * as xtremAppMetadata from '../index';
import { MetaDataType } from './meta-data-type';
export declare class MetaNodeProperty extends Node {
    readonly factory: Reference<xtremAppMetadata.nodes.MetaNodeFactory>;
    readonly name: Promise<string>;
    readonly title: Promise<string>;
    readonly package: Reference<xtremAppMetadata.nodes.MetaPackage>;
    readonly serviceOptionNames: Promise<Dict<string>>;
    readonly serviceOptions: Promise<xtremAppMetadata.nodes.MetaServiceOption[]>;
    readonly isActive: Promise<boolean>;
    readonly type: Promise<xtremAppMetadata.enums.MetaPropertyType>;
    readonly dataType: Reference<MetaDataType>;
    readonly dependencyIndex: Promise<integer>;
    readonly isPublished: Promise<boolean>;
    readonly isStored: Promise<boolean>;
    readonly isTransientInput: Promise<boolean>;
    readonly isStoredOutput: Promise<boolean>;
    readonly isRequired: Promise<boolean>;
    readonly isNullable: Promise<boolean>;
    readonly targetFactory: Reference<xtremAppMetadata.nodes.MetaNodeFactory | null>;
    readonly reverseReference: Reference<MetaNodeProperty | null>;
    readonly isVital: Promise<boolean>;
    readonly isVitalParent: Promise<boolean>;
    readonly isInherited: Promise<boolean>;
    readonly canSort: Promise<boolean>;
    readonly canFilter: Promise<boolean>;
    readonly isOnInputType: Promise<boolean>;
    readonly isOnOutputType: Promise<boolean>;
    readonly isMutable: Promise<boolean>;
}
//# sourceMappingURL=meta-node-property.d.ts.map