import * as React from 'react';
import { Point, XDimension, XRectangleShape } from '../model';
import { VpShapeProps } from './common-props';
interface VpRectangleProps extends VpShapeProps<XRectangleShape> {
    image?: HTMLImageElement | HTMLCanvasElement;
    getTextComponents?: (topLeft: Point, rotation: number, rectangleWidth: number, rectangleHeight: number) => JSX.Element[] | null;
    redrawImage?: (width: number, height: number) => void;
}
export declare class VpRectangle extends React.Component<VpRectangleProps, {}> {
    private groupRef;
    componentDidMount(): void;
    componentDidUpdate(): void;
    attachGroupToTransformer: () => void;
    detachGroupFromTransformer: () => void;
    updateTransformer: () => void;
    onDragStart: (_: import("konva/types/Node").KonvaEventObject<DragEvent>) => void;
    dragEnd: () => void;
    transformEnd: () => void;
    getUpdatedShape: () => {
        shape: {
            xanchors: {
                type: null;
                x: number;
                y: number;
            }[];
            xcaptionPos: import("../model").XPosition | undefined;
            xcaptionSize: XDimension | undefined;
            xtext: string | undefined;
        } | {
            xsize: XDimension;
            xanchors: {
                type: null;
                x: number;
                y: number;
            }[];
            xcaptionPos: import("../model").XPosition | undefined;
            xcaptionSize: XDimension | undefined;
            xtext: string | undefined;
        };
        layerId: string;
        shapeId: string;
    };
    getPointsAndWidthAndHeight: () => {
        topLeft: import("../model").XAnchor;
        topRight: import("../model").XAnchor;
        bottomLeft: import("../model").XAnchor;
        bottomRight: import("../model").XAnchor;
        width: number;
        height: number;
    };
    renderVertices: ({ topLeft, topRight, bottomLeft, bottomRight, center, }: {
        topLeft: Point;
        topRight: Point;
        bottomLeft: Point;
        bottomRight: Point;
        center: Point;
    }) => JSX.Element;
    getImageProperties: (width: number, height: number) => import("konva/types/shapes/Rect").RectConfig;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=vp-rectangle.d.ts.map