import Konva from 'konva';
import * as React from 'react';
import { Point, XDimension, XPosition, XShape } from '../model';
import { Merge } from '../types';
import { TextObject } from '../utils/xmlParser';
import { VpShapeProps } from './common-props';
export interface ShapeWithText extends XShape {
    xcaptionPos: XPosition;
    xcaptionSize: XDimension;
    xcaptionProps?: {
        xvertAlignMode: string;
    };
    xcaptionDeltaPos?: Point;
}
export interface VpTextProps extends Merge<VpShapeProps, {
    shape: ShapeWithText;
}> {
    fontSize?: number;
    parent?: any;
}
export declare function getNewTextAbsolutePosition(group: Konva.Group, shape: ShapeWithText, textObjects: TextObject[]): {
    x: number;
    y: number;
};
export declare const VpLegacyText: React.FC<VpTextProps>;
//# sourceMappingURL=vp-legacy-text.d.ts.map