import Konva from 'konva';
import * as React from 'react';
import { KonvaNodeComponent } from 'react-konva';
import { ShapeWithText } from '../components/vp-legacy-text';
import { ActionState, Dict, XActionProperty, XDocument, XLayer, XLinkProps, XShape } from '../model';
import { UpdateShapeInfo } from '../utils';
import { TextObject } from '../utils/xmlParser';
export interface VpLayerProps extends React.ComponentPropsWithoutRef<KonvaNodeComponent<Konva.Layer, Konva.LayerConfig>> {
    canEdit: boolean;
    isShapeSelected: (id: string) => boolean;
    isShapeHighlighted: (groupRef: React.RefObject<any>) => boolean;
    isInTextEditingMode: boolean;
    setTextEditingMode: (enabled: boolean) => void;
    /** Link content information displayed overlapping the shape */
    isLinkInfoDisplayed: boolean;
    /** Action shape numbers displayed overlapping the shapes */
    areActionNumbersDisplayed: boolean;
    document: XDocument;
    /** Maintain various shape action states  */
    actionStates: Dict<ActionState>;
    /** Trigger and targets of the rule currently selected in the action editor */
    selectedAction: XActionProperty;
    onShapeClick: (layerId: string, shape: XShape, isShiftClick: boolean) => void;
    onShapeDoubleClick: (layerId: string, shapeId: string, groupRef: React.RefObject<any>, isShiftClick: boolean) => void;
    onLinkClick: (xlink: XLinkProps) => void;
    onMouseLeaveShape: () => void;
    onMouseOverShape: () => (shape?: XShape | TextObject) => void;
    /** Event that is triggered en user right clicks on a shape  */
    onShapeRightClick: (layerId: string, shapeId: string) => (evt: Konva.KonvaEventObject<PointerEvent>) => void;
    /** Resolves the images to URLs from for Image shapes */
    resolveImageUrl: (collectionId: string, resourceId: string) => string;
    saveShape: (changes: UpdateShapeInfo) => void;
    onTransformIntoMultipleShapes: (shape: ShapeWithText, textObjects: TextObject[]) => void;
    xlayer: XLayer;
    layerRef: React.RefObject<any>;
    selectionTransformerRef: React.RefObject<any>;
    transformLink: (textObject: TextObject) => void;
    onShowToolbar: (isShow: boolean) => void;
    saveHistoryAndChange: (document: XDocument) => void;
    getDocument: () => XDocument | undefined;
}
export declare function VpLayer(props: VpLayerProps): JSX.Element;
//# sourceMappingURL=vp-layer.d.ts.map