import * as React from 'react';
import { XAction, XActionTargets, XActionTriggers, XDocument, XShape } from '../../model';
import './vp-vertical-toolbar-styles.css';
export declare const getIndexes: (shapeIds: string[], shapes: XShape[]) => string[];
export interface VpVerticalToolbarActionEditorProps {
    document: XDocument | undefined;
    onSaveActions: (actions: XAction[], triggers: XActionTriggers[], targets: XActionTargets[]) => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onCancelActionEditor: () => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onEditActionFieldClick: (triggerValue: string, targetValue: string) => (event: React.MouseEvent<HTMLInputElement, MouseEvent>) => void;
    onEditActionFieldChange: (triggerValue: string, targetValue: string) => void;
    onToggleActionNumbers: () => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onMoveActionEditor: (vertical: boolean) => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
}
export interface VpVerticalToolbarActionEditorState {
    actions: XAction[];
    triggers: XActionTriggers[];
    targets: XActionTargets[];
    actionToHighlight: string;
}
export declare class VpVerticalToolbarActionEditor extends React.Component<VpVerticalToolbarActionEditorProps, VpVerticalToolbarActionEditorState> {
    addNewAction: (actions: XAction[], triggerIndexes: XActionTriggers[], targetIndexes: XActionTargets[]) => void;
    constructor(props: VpVerticalToolbarActionEditorProps);
    onFieldChange: (field: string) => (event: React.ChangeEvent<HTMLInputElement>) => void;
    onTypeChanged: (event: React.ChangeEvent<HTMLSelectElement>) => void;
    onActionRemove: (actionId: string) => () => void;
    renderActionRow: (action: XAction, document: XDocument) => JSX.Element;
    renderActionEditor: (document: XDocument) => JSX.Element;
    render(): JSX.Element;
}
//# sourceMappingURL=vp-vertical-toolbar-action-editor.d.ts.map