import { GraphApi } from '@sage/x3-project-management-api';
import { MobileTimeEntryInquiryByDate } from '@sage/x3-project-management/build/lib/pages/mobile-time-entry-inquiry-by-date';
import { ProjectBillingPlan } from '@sage/x3-sales-project-management-api';
import * as ui from '@sage/xtrem-ui';

@ui.decorators.pageExtension<MobileTimeEntryInquiryByDateExtension>({
    extends: '@sage/x3-project-management/MobileTimeEntryInquiryByDate',
})
export class MobileTimeEntryInquiryByDateExtension extends ui.PageExtension<MobileTimeEntryInquiryByDate, GraphApi> {
    /*
     *
     *  Page properties
     *
     */
    @ui.decorators.referenceField<MobileTimeEntryInquiryByDateExtension, ProjectBillingPlan>({
        parent() {
            return this.projectBillingBlock;
        },
        title: 'Billing plan',
        node: '@sage/x3-sales-project-management/ProjectBillingPlan',
        valueField: 'id',
        helperTextField: 'localizedDescription',
        isReadOnly: true,
        isAutoSelectEnabled: true,
        shouldSuggestionsIncludeColumns: true,
        columns: [
            ui.nestedFields.technical({ bind: 'id' }),
            ui.nestedFields.technical({ bind: 'localizedDescription' }),
        ],
    })
    billingPlan: ui.fields.Reference<ProjectBillingPlan>;
}

declare module '@sage/x3-project-management/build/lib/pages/mobile-time-entry-inquiry-by-date' {
    interface MobileTimeEntryInquiryByDate extends MobileTimeEntryInquiryByDateExtension {}
}
