// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/index.d.ts
declare module '@sage/x3-sales-project-management/index' {
	export * from '@sage/x3-sales-project-management/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/index.d.ts
declare module '@sage/x3-sales-project-management/lib/index' {
	export * as enums from '@sage/x3-sales-project-management/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-sales-project-management/lib/node-extensions/index';
	export * as nodes from '@sage/x3-sales-project-management/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-sales-project-management/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/service-options/index.d.ts
declare module '@sage/x3-sales-project-management/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/nodes/sales-document.d.ts
declare module '@sage/x3-sales-project-management/lib/nodes/sales-document' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3SalesData from '@sage/x3-sales-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class SalesDocument extends Node {
	    readonly id: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly revisionNumber: Promise<integer | null>;
	    readonly documentType: Promise<sageX3ProjectManagementData.enums.SoldProductsDocumentType>;
	    readonly soldToCustomer: Reference<sageX3MasterData.nodes.Customer>;
	    readonly date: Promise<date>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly customerReference: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
	    readonly reverse: Promise<decimal>;
	    readonly divisor: Promise<decimal>;
	    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
	    readonly priceIncludingOrExcludingTax: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
	    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm | null>;
	    readonly documentNumber: Promise<string>;
	    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType | null>;
	    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.Address | null>;
	    readonly billToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly payByBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly requestedDeliveryDate: Promise<date | null>;
	    readonly shipmentDate: Promise<date | null>;
	    readonly salesInvoiceType: Reference<sageX3SalesData.nodes.SalesInvoiceType | null>;
	    readonly salesOrderType: Reference<sageX3SalesData.nodes.SalesOrderType | null>;
	    readonly salesQuoteType: Reference<sageX3SalesData.nodes.SalesQuoteType | null>;
	    readonly dueDateCalculationStartDate: Promise<date | null>;
	    readonly validityDate: Promise<date | null>;
	    readonly lines: Collection<sageX3SalesProjectManagement.nodes.SalesDocumentLine>;
	}
	//# sourceMappingURL=sales-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/nodes/sales-document-line.d.ts
declare module '@sage/x3-sales-project-management/lib/nodes/sales-document-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagement from '@sage/x3-project-management';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	export class SalesDocumentLine extends Node {
	    readonly projectDocument: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly documentLineNumber: Promise<integer | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly revisionNumber: Promise<integer | null>;
	    readonly budget: Promise<string>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly productDescription: Promise<string>;
	    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorProductVersion: Promise<string>;
	    readonly plannedQuantity: Promise<decimal | null>;
	    readonly plannedUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly documentQuantity: Promise<decimal>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly basePrice: Promise<decimal | null>;
	    readonly doApplyBasePrice: Promise<boolean>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly documentType: Promise<sageX3ProjectManagementData.enums.SoldProductsDocumentType>;
	    readonly documentNumber: Promise<string>;
	    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	}
	//# sourceMappingURL=sales-document-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/nodes/project-billing-plan.d.ts
declare module '@sage/x3-sales-project-management/lib/nodes/project-billing-plan' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagement from '@sage/x3-project-management';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3Sales from '@sage/x3-sales';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, Collection } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class ProjectBillingPlan extends Node {
	    readonly id: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly salesOrderNumber: Reference<sageX3Sales.nodes.SalesOrder>;
	    readonly salesOrderLineNumber: Promise<integer>;
	    readonly salesOrderSequenceNumber: Promise<integer>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly periodStart: Promise<date | null>;
	    readonly periodEnd: Promise<date | null>;
	    readonly lines: Collection<sageX3SalesProjectManagement.nodes.ProjectBillingPlanLine>;
	}
	//# sourceMappingURL=project-billing-plan.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/nodes/project-billing-plan-line.d.ts
declare module '@sage/x3-sales-project-management/lib/nodes/project-billing-plan-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3Sales from '@sage/x3-sales';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class ProjectBillingPlanLine extends Node {
	    readonly billingPlan: Reference<sageX3SalesProjectManagement.nodes.ProjectBillingPlan>;
	    readonly lineNumber: Promise<integer>;
	    readonly documentType: Promise<sageX3ProjectManagementData.enums.Origin>;
	    readonly status: Promise<sageX3ProjectManagementData.enums.ProgressBillingLineStatus>;
	    readonly isValidated: Promise<boolean>;
	    readonly isRefreshRequested: Promise<boolean>;
	    readonly localizedDescription: Promise<string>;
	    readonly periodStart: Promise<date>;
	    readonly periodEnd: Promise<date>;
	    readonly nextInvoiceDate: Promise<date>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly estimationDate: Promise<date | null>;
	    readonly estimatedProgress: Promise<decimal | null>;
	    readonly estimatedQuantity: Promise<decimal | null>;
	    readonly estimatedAmount: Promise<decimal | null>;
	    readonly billedProgress: Promise<decimal | null>;
	    readonly billedQuantity: Promise<decimal | null>;
	    readonly billedAmount: Promise<decimal | null>;
	    readonly cumulatedQuantity: Promise<decimal | null>;
	    readonly cumulatedAmount: Promise<decimal | null>;
	    readonly remainingQuantity: Promise<decimal | null>;
	    readonly remainingAmount: Promise<decimal | null>;
	    readonly createdOn: Promise<date>;
	    readonly createdBy: Reference<sageX3System.nodes.User>;
	    readonly updatedOn: Promise<date | null>;
	    readonly updatedBy: Reference<sageX3System.nodes.User | null>;
	    readonly validatedOn: Promise<date | null>;
	    readonly validatedBy: Reference<sageX3System.nodes.User | null>;
	    readonly adjustedOn: Promise<date | null>;
	    readonly adjustedBy: Reference<sageX3System.nodes.User | null>;
	    readonly adjustedValue: Promise<sageX3ProjectManagementData.enums.AdjustedValue>;
	    readonly salesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
	    readonly salesInvoiceLine: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
	}
	//# sourceMappingURL=project-billing-plan-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/nodes/index.d.ts
declare module '@sage/x3-sales-project-management/lib/nodes/index' {
	export * from '@sage/x3-sales-project-management/lib/nodes/project-billing-plan-line';
	export * from '@sage/x3-sales-project-management/lib/nodes/project-billing-plan';
	export * from '@sage/x3-sales-project-management/lib/nodes/sales-document-line';
	export * from '@sage/x3-sales-project-management/lib/nodes/sales-document';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/time-entry-line-extension.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/time-entry-line-extension' {
	import * as sageX3ProjectManagement from '@sage/x3-project-management';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class TimeEntryLineExtension extends NodeExtension<sageX3ProjectManagement.nodes.TimeEntryLine> {
	    readonly billingPlan: Reference<sageX3SalesProjectManagement.nodes.ProjectBillingPlan | null>;
	    readonly billingPlanLine: Reference<sageX3SalesProjectManagement.nodes.ProjectBillingPlanLine | null>;
	}
	declare module '@sage/x3-project-management/lib/nodes/time-entry-line' {
	    interface TimeEntryLine extends TimeEntryLineExtension {
	    }
	}
	//# sourceMappingURL=time-entry-line-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/sales-quote-line-extension.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/sales-quote-line-extension' {
	import * as sageX3Sales from '@sage/x3-sales';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class SalesQuoteLineExtension extends NodeExtension<sageX3Sales.nodes.SalesQuoteLine> {
	    readonly projectSalesDocument: Reference<sageX3SalesProjectManagement.nodes.SalesDocument | null>;
	    readonly projectSalesDocumentLine: Reference<sageX3SalesProjectManagement.nodes.SalesDocumentLine | null>;
	}
	declare module '@sage/x3-sales/lib/nodes/sales-quote-line' {
	    interface SalesQuoteLine extends SalesQuoteLineExtension {
	    }
	}
	//# sourceMappingURL=sales-quote-line-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/sales-order-quantity-line-extension.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/sales-order-quantity-line-extension' {
	import * as sageX3Sales from '@sage/x3-sales';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class SalesOrderQuantityLineExtension extends NodeExtension<sageX3Sales.nodes.SalesOrderQuantityLine> {
	    readonly projectSalesDocument: Reference<sageX3SalesProjectManagement.nodes.SalesDocument | null>;
	    readonly projectSalesDocumentLine: Reference<sageX3SalesProjectManagement.nodes.SalesDocumentLine | null>;
	    readonly projectBillingPlan: Reference<sageX3SalesProjectManagement.nodes.ProjectBillingPlan | null>;
	}
	declare module '@sage/x3-sales/lib/nodes/sales-order-quantity-line' {
	    interface SalesOrderQuantityLine extends SalesOrderQuantityLineExtension {
	    }
	}
	//# sourceMappingURL=sales-order-quantity-line-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/sales-order-line-extension.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/sales-order-line-extension' {
	import * as sageX3Sales from '@sage/x3-sales';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class SalesOrderLineExtension extends NodeExtension<sageX3Sales.nodes.SalesOrderLine> {
	    readonly projectBillingPlan: Reference<sageX3SalesProjectManagement.nodes.ProjectBillingPlan | null>;
	    readonly projectSalesDocument: Reference<sageX3SalesProjectManagement.nodes.SalesDocument | null>;
	    readonly projectSalesDocumentLine: Reference<sageX3SalesProjectManagement.nodes.SalesDocumentLine | null>;
	}
	declare module '@sage/x3-sales/lib/nodes/sales-order-line' {
	    interface SalesOrderLine extends SalesOrderLineExtension {
	    }
	}
	//# sourceMappingURL=sales-order-line-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/sales-invoice-line-extension.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/sales-invoice-line-extension' {
	import * as sageX3Sales from '@sage/x3-sales';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class SalesInvoiceLineExtension extends NodeExtension<sageX3Sales.nodes.SalesInvoiceLine> {
	    readonly projectSalesDocument: Reference<sageX3SalesProjectManagement.nodes.SalesDocument | null>;
	    readonly projectSalesDocumentLine: Reference<sageX3SalesProjectManagement.nodes.SalesDocumentLine | null>;
	}
	declare module '@sage/x3-sales/lib/nodes/sales-invoice-line' {
	    interface SalesInvoiceLine extends SalesInvoiceLineExtension {
	    }
	}
	//# sourceMappingURL=sales-invoice-line-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/saleable-product-extension.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/saleable-product-extension' {
	import * as sageX3ProjectManagement from '@sage/x3-project-management';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesProjectManagement from '@sage/x3-sales-project-management/lib/index';
	export class SaleableProductExtension extends NodeExtension<sageX3ProjectManagement.nodes.SaleableProduct> {
	    readonly salesDocument: Reference<sageX3SalesProjectManagement.nodes.SalesDocument | null>;
	    readonly salesDocumentLine: Reference<sageX3SalesProjectManagement.nodes.SalesDocumentLine | null>;
	}
	declare module '@sage/x3-project-management/lib/nodes/saleable-product' {
	    interface SaleableProduct extends SaleableProductExtension {
	    }
	}
	//# sourceMappingURL=saleable-product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-sales-project-management/lib/node-extensions/index' {
	export * from '@sage/x3-sales-project-management/lib/node-extensions/saleable-product-extension';
	export * from '@sage/x3-sales-project-management/lib/node-extensions/sales-invoice-line-extension';
	export * from '@sage/x3-sales-project-management/lib/node-extensions/sales-order-line-extension';
	export * from '@sage/x3-sales-project-management/lib/node-extensions/sales-order-quantity-line-extension';
	export * from '@sage/x3-sales-project-management/lib/node-extensions/sales-quote-line-extension';
	export * from '@sage/x3-sales-project-management/lib/node-extensions/time-entry-line-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-sales-project-management/build/lib/enums/index.d.ts
declare module '@sage/x3-sales-project-management/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-sales-project-management' {
	export * from '@sage/x3-sales-project-management/index';
}
