import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagement from '@sage/x3-project-management';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
export declare class SalesDocumentLine extends Node {
    readonly projectDocument: Promise<string>;
    readonly lineNumber: Promise<integer>;
    readonly documentLineNumber: Promise<integer | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly revisionNumber: Promise<integer | null>;
    readonly budget: Promise<string>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescription: Promise<string>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly plannedQuantity: Promise<decimal | null>;
    readonly plannedUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly documentQuantity: Promise<decimal>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly basePrice: Promise<decimal | null>;
    readonly doApplyBasePrice: Promise<boolean>;
    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly documentType: Promise<sageX3ProjectManagementData.enums.SoldProductsDocumentType>;
    readonly documentNumber: Promise<string>;
    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
}
//# sourceMappingURL=sales-document-line.d.ts.map