"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectBillingPlanLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3Sales = require("@sage/x3-sales");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3SalesProjectManagement = require("..");
const joins = {
    referenceJoins: {
        billingPlan: {
            id: 'billingPlan',
        },
        currency: {
            code: 'currency',
        },
        unit: {
            code: 'unit',
        },
        createdBy: {
            code: 'createdBy',
        },
        updatedBy: {
            code: 'updatedBy',
        },
        validatedBy: {
            code: 'validatedBy',
        },
        adjustedBy: {
            code: 'adjustedBy',
        },
        salesInvoice: {
            id: 'salesInvoice',
        },
        salesInvoiceLine: {
            salesInvoice: 'salesInvoice',
            lineNumber: 'salesInvoiceLine',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMPRGBILD';
            },
            columnName() {
                return 'DESAXX';
            },
            key1: ['billingPlan', 'lineNumber'],
        },
    },
};
let ProjectBillingPlanLine = class ProjectBillingPlanLine extends xtrem_core_1.Node {
};
exports.ProjectBillingPlanLine = ProjectBillingPlanLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRGBILNUM',
        columnType: 'string',
        node: () => sageX3SalesProjectManagement.nodes.ProjectBillingPlan,
    })
], ProjectBillingPlanLine.prototype, "billingPlan", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SEQLIN',
    })
], ProjectBillingPlanLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYPECH',
        dataType: () => sageX3ProjectManagementData.enums.originDatatype,
    })
], ProjectBillingPlanLine.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STA',
        dataType: () => sageX3ProjectManagementData.enums.progressBillingLineStatusDatatype,
    })
], ProjectBillingPlanLine.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VALLIN',
    })
], ProjectBillingPlanLine.prototype, "isValidated", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TBECHK',
    })
], ProjectBillingPlanLine.prototype, "isRefreshRequested", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], ProjectBillingPlanLine.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PERSTRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "periodStart", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PERENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "periodEnd", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NEXINVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "nextInvoiceDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], ProjectBillingPlanLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], ProjectBillingPlanLine.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "estimationDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLCAL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "estimatedProgress", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYCPLCAL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "estimatedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTCPLCAL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "estimatedAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLENT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "billedProgress", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYCPLENT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "billedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTCPLENT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "billedAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUMQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "cumulatedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUMAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "cumulatedAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REMQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "remainingQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REMAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], ProjectBillingPlanLine.prototype, "remainingAmount", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECHCREDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "createdOn", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECHCREUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], ProjectBillingPlanLine.prototype, "createdBy", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECHUPDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "updatedOn", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECHUPDUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], ProjectBillingPlanLine.prototype, "updatedBy", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECHVALDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "validatedOn", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECHVALUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], ProjectBillingPlanLine.prototype, "validatedBy", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECHADJDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], ProjectBillingPlanLine.prototype, "adjustedOn", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECHADJUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], ProjectBillingPlanLine.prototype, "adjustedBy", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECHADJPRO',
        dataType: () => sageX3ProjectManagementData.enums.adjustedValueDatatype,
    })
], ProjectBillingPlanLine.prototype, "adjustedValue", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIHNUM',
        columnType: 'string',
        node: () => sageX3Sales.nodes.SalesInvoice,
    })
], ProjectBillingPlanLine.prototype, "salesInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SIDLIN',
        columnType: 'integer',
        node: () => sageX3Sales.nodes.SalesInvoiceLine,
    })
], ProjectBillingPlanLine.prototype, "salesInvoiceLine", void 0);
exports.ProjectBillingPlanLine = ProjectBillingPlanLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMPRGBILD',
        keyPropertyNames: ['billingPlan', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    billingPlan: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], ProjectBillingPlanLine);
//# sourceMappingURL=project-billing-plan-line.js.map