import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3Sales from '@sage/x3-sales';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageX3SalesProjectManagement from '..';
export declare class ProjectBillingPlanLine extends Node {
    readonly billingPlan: Reference<sageX3SalesProjectManagement.nodes.ProjectBillingPlan>;
    readonly lineNumber: Promise<integer>;
    readonly documentType: Promise<sageX3ProjectManagementData.enums.Origin>;
    readonly status: Promise<sageX3ProjectManagementData.enums.ProgressBillingLineStatus>;
    readonly isValidated: Promise<boolean>;
    readonly isRefreshRequested: Promise<boolean>;
    readonly localizedDescription: Promise<string>;
    readonly periodStart: Promise<date>;
    readonly periodEnd: Promise<date>;
    readonly nextInvoiceDate: Promise<date>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly estimationDate: Promise<date | null>;
    readonly estimatedProgress: Promise<decimal | null>;
    readonly estimatedQuantity: Promise<decimal | null>;
    readonly estimatedAmount: Promise<decimal | null>;
    readonly billedProgress: Promise<decimal | null>;
    readonly billedQuantity: Promise<decimal | null>;
    readonly billedAmount: Promise<decimal | null>;
    readonly cumulatedQuantity: Promise<decimal | null>;
    readonly cumulatedAmount: Promise<decimal | null>;
    readonly remainingQuantity: Promise<decimal | null>;
    readonly remainingAmount: Promise<decimal | null>;
    readonly createdOn: Promise<date>;
    readonly createdBy: Reference<sageX3System.nodes.User>;
    readonly updatedOn: Promise<date | null>;
    readonly updatedBy: Reference<sageX3System.nodes.User | null>;
    readonly validatedOn: Promise<date | null>;
    readonly validatedBy: Reference<sageX3System.nodes.User | null>;
    readonly adjustedOn: Promise<date | null>;
    readonly adjustedBy: Reference<sageX3System.nodes.User | null>;
    readonly adjustedValue: Promise<sageX3ProjectManagementData.enums.AdjustedValue>;
    readonly salesInvoice: Reference<sageX3Sales.nodes.SalesInvoice | null>;
    readonly salesInvoiceLine: Reference<sageX3Sales.nodes.SalesInvoiceLine | null>;
}
//# sourceMappingURL=project-billing-plan-line.d.ts.map