import { Filter } from './filters';
import { OrderBy } from './order-by';
import { OnlySelected, Selector } from './selector';
export type WithoutEdges<T> = {
    [K in keyof T]: T[K] extends object ? T[K] extends EdgesMatcher<infer U> ? WithoutEdges<U>[] : WithoutEdges<T[K]> : T[K];
};
/**
 * {
 *     query: Array<{edges: { node: T }}>;
 *     readAggregate: AggregateResultValues<T>;     =>      T[]
 *     queryAggregate: AggregateEdges<T>;
 * }
 */
export type ExtractEdges<T> = {
    [K in keyof T]: T[K] extends object ? T[K] extends EdgesMatcher<infer U> | ClientCollectionMatcher<infer U> ? ExtractEdges<U>[] : ExtractEdges<T[K]> : T[K];
};
export type ExtractEdgesPartial<T> = {
    [K in keyof T]?: T[K] extends object ? T[K] extends EdgesMatcher<infer U> | ClientCollectionMatcher<infer U> ? ExtractEdgesPartial<U>[] : ExtractEdgesPartial<T[K]> : T[K];
};
export interface Query<T> {
    query: Edges<T>;
}
export interface EdgesMatcher<T> {
    edges: {
        node: T;
    }[];
}
export interface ClientCollectionMatcher<T> {
    query: EdgesMatcher<T>;
}
export interface BinaryStreamMatcher {
    value: string;
}
export interface Edges<T> {
    edges: {
        node: T;
        cursor: string | null;
    }[];
    pageInfo: {
        hasNextPage: boolean;
        endCursor: string | null;
        hasPreviousPage: boolean;
        startCursor: string | null;
    };
    totalCount?: number;
}
export interface PagingOptions<T> {
    first?: number;
    after?: string;
    last?: number;
    before?: string;
    orderBy?: OrderBy<T extends infer U ? U : never>;
    filter?: Filter<T extends infer V ? V : never>;
}
export interface PagingOptionsSelector {
    first?: number;
    after?: string;
    last?: number;
    before?: string;
    orderBy?: string;
    filter?: string;
}
export type WithoutSelectedEdges<T, SelectorT extends Selector<T>> = WithoutEdges<OnlySelected<T, SelectorT>>;
/**
 * Recursively transforms "edges":
 *
 * Array<{edges: { node: T }}> => T[]
 *
 * "query", "queryAggregate" & "readAggregate" are PRESERVED.
 *
 * @export
 * @template T
 * @param {Edges<T>} edges
 * @returns {WithoutEdges<T>[]}
 */
export declare function withoutEdges<T>(edges: Edges<T>): WithoutEdges<T>[];
/**
 * Recursively extract "edges" from queries:
 *
 * * {
 *     query: Array<{edges: { node: T }}>;
 *     readAggregate: AggregateResultValues<T>;     =>      T[]
 *     queryAggregate: AggregateEdges<T>;
 * }
 *
 * "query", "queryAggregate" & "readAggregate" are REMOVED.
 * Use "withoutEdges" if you want to keep them.
 * @export
 * @template T
 * @param {Edges<T>} edges
 * @returns {ExtractEdges<T>[]}
 */
export declare function extractEdges<T>(edges: Edges<T>): ExtractEdges<T>[];
export interface EdgesSelector<SelectorT> {
    __args?: PagingOptionsSelector;
    edges: {
        node: SelectorT;
        cursor?: boolean;
    };
    pageInfo?: {
        hasNextPage?: boolean;
        endCursor?: boolean;
        hasPreviousPage?: boolean;
        startCursor?: boolean;
    };
    totalCount?: boolean;
}
export declare function edgesSelector<T, SelectorT = Selector<T>>(selector: SelectorT, args?: PagingOptions<T>): EdgesSelector<SelectorT>;
export interface QuerySelector<T, SelectorT = Selector<T>> {
    query: EdgesSelector<SelectorT>;
}
export declare function querySelector<T, SelectorT = Selector<T>>(selector: SelectorT, args?: PagingOptions<T>): QuerySelector<T, SelectorT>;
//# sourceMappingURL=paging.d.ts.map