"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.runToCompletionOperation = exports.scalarIdOperation = exports.scalarOperation = exports.nodeIdOperation = exports.nodeOperation = void 0;
const request_1 = require("./request");
const selector_1 = require("./selector");
/** @internal */
const nodeOperation = (config, path, name, isMutation) => {
    return (selector, args) => {
        const full = (0, selector_1.fullSelector)(path, { [name]: args && Object.keys(args).length ? { __args: args, ...selector } : selector }, isMutation);
        return new request_1.Request(config, path, name, full, isMutation);
    };
};
exports.nodeOperation = nodeOperation;
/** @internal */
const nodeIdOperation = (config, path, name, isMutation) => (selector, args) => {
    const argsObj = typeof args === 'string' ? { _id: args } : args;
    const full = (0, selector_1.fullSelector)(path, { [name]: { __args: argsObj, ...selector } }, isMutation);
    return new request_1.Request(config, path, name, full, isMutation);
};
exports.nodeIdOperation = nodeIdOperation;
/** @internal */
const scalarOperation = (config, path, name, isMutation) => (args) => {
    const full = (0, selector_1.fullSelector)(path, { [name]: { __args: args } }, isMutation);
    return new request_1.Request(config, path, name, full, isMutation);
};
exports.scalarOperation = scalarOperation;
/** @internal */
const scalarIdOperation = (config, path, name, isMutation) => (args) => {
    const full = (0, selector_1.fullSelector)(path, { [name]: { __args: { _id: args } } }, isMutation);
    return new request_1.Request(config, path, name, full, isMutation);
};
exports.scalarIdOperation = scalarIdOperation;
const sleepMillis = (millis) => new Promise(resolve => {
    setTimeout(resolve, millis);
});
const runToCompletionOperation = (config, path) => {
    return (selector, args, options) => {
        const startMutation = (0, exports.nodeOperation)(config, path, 'start', true);
        const trackMutation = (0, exports.nodeOperation)(config, path, 'track', false);
        return {
            async execute() {
                const trackingId = await startMutation({ trackingId: true }, args).execute();
                let running = true;
                const startMillis = Date.now();
                let pollCount = 1;
                while (running) {
                    const response = await trackMutation({ status: true, result: selector, errorMessage: true }, trackingId).execute();
                    switch (response.status) {
                        case 'pending':
                        case 'running':
                            break;
                        case 'success':
                            return response.result;
                        case 'error':
                            throw new Error(response.errorMessage || '<unknown error>');
                        default:
                            throw new Error(`invalid status: ${response.status}`);
                    }
                    if (options?.callback)
                        running = options.callback({
                            pollCount,
                            elapsedMillis: Date.now() - startMillis,
                            status: response.status,
                        });
                    // Ramp up sleep time from 100 to 1000 and then remain at 1000.
                    await sleepMillis(Math.min(pollCount * 100, 1000));
                    pollCount += 1;
                }
                throw new Error('polling cancelled');
            },
        };
    };
};
exports.runToCompletionOperation = runToCompletionOperation;
//# sourceMappingURL=operations.js.map