"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.nodeQueries = exports.lookupsOperation = void 0;
const operations_1 = require("./operations");
const request_1 = require("./request");
const selector_1 = require("./selector");
const queryOperation = (config, path) => (selector) => {
    // const full = queryOperationSelector(path, selector, false);
    const full = (0, selector_1.fullSelector)([...path, 'query'], selector, false);
    return new request_1.Request(config, [...path, 'query'], '', full, false);
};
/** @internal */
const lookupsOperation = (config, path, dataOrId, propertyName) => (propertySelector) => {
    const lookupsArgs = typeof dataOrId === 'string' ? { _id: dataOrId } : dataOrId;
    const full = (0, selector_1.fullSelector)(path, { lookups: { __args: lookupsArgs, [propertyName]: propertySelector } }, false);
    return new request_1.Request(config, [...path, 'lookups'], propertyName, full, false);
};
exports.lookupsOperation = lookupsOperation;
/** @internal */
const nodeQueries = (config, path) => {
    return {
        // built-in queries
        query: queryOperation(config, path),
        read: (0, operations_1.nodeIdOperation)(config, path, 'read', false),
        getDuplicate: (0, operations_1.nodeIdOperation)(config, path, 'getDuplicate', false),
        getDefaults: (0, operations_1.nodeOperation)(config, path, 'getDefaults', false),
        lookups: (dataOrId) => {
            return new Proxy({}, {
                get(dummy, propertyName) {
                    if (typeof propertyName !== 'string')
                        throw new Error(`${path.join('/')}: bad proxy request: ${typeof propertyName}`);
                    return (0, exports.lookupsOperation)(config, path, dataOrId, propertyName);
                },
            });
        },
        // custom queries
        queries: new Proxy({}, {
            get(dummy, name) {
                if (typeof name !== 'string')
                    throw new Error(`${path.join('/')}: bad proxy request: ${typeof name}`);
                return (0, operations_1.nodeOperation)(config, path, name, false);
            },
        }),
    };
};
exports.nodeQueries = nodeQueries;
//# sourceMappingURL=node-queries.js.map