import { Operation } from './operations';
import { Request } from './request';
export type CreateOperation<InputT, OutputT> = Operation<{
    data: InputT;
}, OutputT>;
export type DuplicateOperation<InputT, OutputT> = Operation<{
    _id: string;
    data?: InputT;
}, OutputT>;
export type UpdateOperation<InputT, OutputT> = Operation<{
    data: InputT;
}, OutputT>;
export type UpdateByIdOperation<InputT, OutputT> = Operation<{
    _id: string;
    data: InputT;
}, OutputT>;
export type DeleteOperation<KeyT> = (args: KeyT) => Request<number>;
//# sourceMappingURL=node-mutations.d.ts.map