"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchRequest = void 0;
const json_to_graphql_query_1 = require("json-to-graphql-query");
class BatchRequest {
    constructor(requests) {
        this.requests = requests;
        const keys = Object.keys(this.requests);
        if (keys.length > 0)
            this.config = this.requests[keys[0]].config;
        if (keys.length > 1 &&
            keys.slice(1).some(k => this.requests[k].isMutation !== this.requests[keys[0]].isMutation)) {
            throw new Error('invalid batch request: cannot mix queries and mutations in the same request');
        }
    }
    /** @internal */
    isEmpty() {
        return Object.keys(this.requests).length === 0;
    }
    /** @internal */
    mergeSelectors() {
        return Object.keys(this.requests).reduce((r, k) => {
            const request = this.requests[k];
            const typeKey = request.isMutation ? 'mutation' : 'query';
            r[typeKey] = r[typeKey] || {};
            const subKey = Object.keys(request.selector[typeKey])[0];
            r[typeKey][k] = {
                ...request.selector[typeKey][subKey],
                __aliasFor: subKey,
            };
            return r;
        }, {});
    }
    /** @internal */
    unwrapResult(results) {
        return Object.keys(this.requests).reduce((r, k) => {
            const request = this.requests[k];
            const result = results.data[k];
            r[k] = request.unwrapBatchResult(result);
            return r;
        }, {});
    }
    async execute() {
        if (this.isEmpty())
            return {};
        const selector = this.mergeSelectors();
        const query = (0, json_to_graphql_query_1.jsonToGraphQLQuery)(selector, { pretty: true });
        if (this.config.log)
            this.config.log('BATCH QUERY', query);
        const results = await this.config.fetcher(query);
        if (this.config.log)
            this.config.log('BATCH RESULT', results);
        return this.unwrapResult(results);
    }
}
exports.BatchRequest = BatchRequest;
//# sourceMappingURL=batch-request.js.map