/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.helper.SpecHelper;
import com.sage.izpack.ModifyInstallationUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateListener
extends AbstractProgressInstallerListener {
    private final SpecHelper spec;
    private Resources resources;
    public static final String BEFORE_UPDATE_SCRIPT = "BeforeUpdateScript";
    public static final String BEFORE_UPDATE_SCRIPT_PS = "BeforeUpdateScriptPs";
    public static final String BEFORE_INSTALL_SCRIPT = "BeforeInstallScript";
    public static final String BEFORE_INSTALL_SCRIPT_PS = "BeforeInstallScriptPs";
    public static final String AFTER_UPDATE_SCRIPT = "AfterUpdateScript";
    public static final String AFTER_INSTALL_SCRIPT = "AfterInstallScript";
    public static final String PLATFORM = OsVersion.IS_UNIX ? "unix" : "windows";
    private static String prefixLabel = "UpdateListener.fetchAndExecuteResource ";
    private static final Logger logger = Logger.getLogger(UpdateListener.class.getName());

    public UpdateListener(InstallData installData, Resources resources) {
        super(installData);
        this.resources = resources;
        this.spec = new SpecHelper(resources);
    }

    public void cleanUp() {
    }

    @Override
    public void afterPacks(List<Pack> packs, ProgressListener listener) {
        try {
            super.afterPacks(packs, listener);
            if (ModifyInstallationUtil.get(this.getInstallData()).booleanValue()) {
                this.fetchAndExecuteResource("AfterUpdateScript_" + PLATFORM, null, this.getInstallData());
            } else {
                this.fetchAndExecuteResource("AfterInstallScript_" + PLATFORM, null, this.getInstallData());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void afterPack(Pack pack) throws InstallerException {
    }

    @Override
    public void beforePacks(List<Pack> packs, ProgressListener listener) {
        try {
            super.beforePacks(packs, listener);
            this.beforePacksCommon();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void beforePack(Pack pack) {
    }

    private void beforePacksCommon() throws Exception {
        if (ModifyInstallationUtil.get(this.getInstallData()).booleanValue()) {
            this.fetchAndExecuteResource("BeforeUpdateScript_" + PLATFORM, "BeforeUpdateScriptPs_" + PLATFORM, this.getInstallData());
        } else {
            this.fetchAndExecuteResource("BeforeInstallScript_" + PLATFORM, "BeforeInstallScriptPs_" + PLATFORM, this.getInstallData());
        }
    }

    public void fetchAndExecuteResource(String resource, String resourcePs, InstallData installData) throws Exception {
        logger.log(Level.FINE, prefixLabel + "( resource: " + resource + " resourcePs:" + resourcePs + ")");
        File tempFilePs = this.createTempFile(installData, resourcePs, resourcePs, ".ps1");
        if (tempFilePs != null) {
            if (ModifyInstallationUtil.get(this.getInstallData()).booleanValue()) {
                installData.setVariable("BEFORE_UPDATE_SCRIPT_PS", tempFilePs.getName());
                installData.setVariable("BEFORE_UPDATE_SCRIPT_PS_PATH", tempFilePs.getPath());
                logger.log(Level.FINE, prefixLabel + "resourcePs:" + resourcePs + "  Temp file created: " + tempFilePs.getAbsolutePath() + "  Add variable " + BEFORE_UPDATE_SCRIPT_PS + ":" + tempFilePs.getName());
            } else {
                installData.setVariable("BEFORE_INSTALL_SCRIPT_PS", tempFilePs.getName());
                installData.setVariable("BEFORE_INSTALL_SCRIPT_PS_PATH", tempFilePs.getPath());
                logger.log(Level.FINE, prefixLabel + "resourcePs:" + resourcePs + "  Temp file created: " + tempFilePs.getAbsolutePath() + "  Add variable " + BEFORE_INSTALL_SCRIPT_PS + ":" + tempFilePs.getName());
            }
        } else {
            logger.log(Level.FINE, prefixLabel + "NO resource found for resourcePs:" + resourcePs);
        }
        String ext = OsVersion.IS_UNIX ? ".sh" : ".cmd";
        File tempFile = this.createTempFile(installData, resource, resource, ext);
        if (tempFile != null) {
            logger.log(Level.FINE, prefixLabel + "resource:" + resource + "  Temp file created: " + tempFile.getAbsolutePath());
            ProcessBuilder procBuilder = null;
            procBuilder = OsVersion.IS_UNIX ? new ProcessBuilder(System.getenv("SHELL"), tempFile.getAbsolutePath()) : new ProcessBuilder("cmd.exe", "/C", tempFile.getAbsolutePath());
            logger.log(Level.FINE, prefixLabel + "launching " + tempFile.getAbsolutePath());
            Process p = procBuilder.start();
            BufferedInputStream errorOutput = new BufferedInputStream(p.getErrorStream(), 10000);
            BufferedInputStream consoleOutput = new BufferedInputStream(p.getInputStream(), 10000);
            logger.log(Level.FINE, prefixLabel + "errorOutput:");
            BufferedReader brErrorOutput = new BufferedReader(new InputStreamReader(errorOutput));
            String readErrorOutput = brErrorOutput.readLine();
            while (readErrorOutput != null) {
                logger.log(Level.FINE, readErrorOutput);
                readErrorOutput = brErrorOutput.readLine();
            }
            logger.log(Level.FINE, prefixLabel + "consoleOutput:");
            BufferedReader brOutput = new BufferedReader(new InputStreamReader(consoleOutput));
            String read2 = brOutput.readLine();
            while (read2 != null) {
                logger.log(Level.FINE, read2);
                read2 = brOutput.readLine();
            }
            int exitCode = p.waitFor();
            logger.log(Level.FINE, prefixLabel + "ExitCode: " + exitCode);
            if (exitCode != 0) {
                logger.log(Level.FINE, prefixLabel + "Command failed: " + procBuilder.command());
                throw new InstallerException(resource + " return code is " + exitCode + " !");
            }
        } else {
            logger.log(Level.FINE, prefixLabel + "NO resource found for resource:" + resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createTempFile(InstallData installData, String resource, String fileName, String ext) {
        File tempFile = null;
        try {
            InputStream inputStream = this.spec.getResource(resource);
            if (inputStream == null && this.resources != null) {
                inputStream = this.resources.getInputStream(resource);
            }
            if (inputStream == null) {
                logger.log(Level.FINE, prefixLabel + "Cannot createTempFile(" + resource + ", " + fileName + ext + ") ");
                return null;
            }
            logger.log(Level.FINE, prefixLabel + "createTempFile(" + resource + ", " + fileName + ext + ") ");
            tempFile = File.createTempFile(fileName, ext);
            tempFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tempFile);
            VariableSubstitutorImpl substitutor = new VariableSubstitutorImpl(installData.getVariables());
            substitutor.substitute(inputStream, fos, SubstitutionType.TYPE_PLAIN, "UTF-8");
            fos.close();
            return tempFile;
        }
        catch (ResourceNotFoundException resNotFound) {
            logger.log(Level.FINE, prefixLabel + "Resource not found: " + resource + " " + resNotFound.getMessage());
            return null;
        }
        catch (ResourceException resEx) {
            logger.log(Level.FINE, prefixLabel + "Resource error: " + resource + " " + resEx.getMessage());
            return null;
        }
        catch (IOException ex) {
            logger.log(Level.FINE, prefixLabel + "" + ex.getMessage());
            throw new InstallerException(prefixLabel + "I/O error during writing resource " + resource + " to a temporary buildfile", ex);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, prefixLabel + "Resource gerror: " + resource + " " + ex.getMessage());
            return null;
        }
    }
}

