/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.RegistryUninstallerListener;
import com.izforge.izpack.util.Platforms;
import com.sage.izpack.AdxCompUninstallerListener;
import com.sage.izpack.InstallDataSage;
import com.sage.izpack.InstallationInformationHelper;
import com.sage.izpack.ResourcesHelper;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistryUninstallerNewListener
extends RegistryUninstallerListener {
    private static final Logger logger = Logger.getLogger(RegistryUninstallerNewListener.class.getName());
    private static final String LogPrefix = "RegistryUninstallerNewListener - ";
    private RegistryDefaultHandler myhandler;
    private final Prompt prompt;
    private final Resources resources;
    private final Messages messages;
    private AdxCompUninstallerListener adxCompUninstallerListener = null;

    public RegistryUninstallerNewListener(RegistryDefaultHandler handler, Resources resources, Messages messages, Prompt prompt) {
        super(handler, resources, messages);
        this.myhandler = handler;
        this.resources = resources;
        this.messages = messages;
        this.prompt = prompt;
    }

    @Override
    public void afterDelete(File file) {
        logger.log(Level.FINE, "RegistryUninstallerNewListener - afterDelete. File : " + file);
        System.out.println("RegistryUninstallerNewListener - afterDelete. File : " + file);
        super.afterDelete(file);
    }

    @Override
    public void beforeDelete(List<File> files, ProgressListener listener) {
        logger.log(Level.FINE, "RegistryUninstallerNewListener - beforeDelete.  ");
        System.out.println("RegistryUninstallerNewListener - beforeDelete.  ");
        try {
            super.beforeDelete(files, listener);
        }
        catch (WrappedNativeLibException exception) {
            this.emitError(this.getString("privilegesIssue", "It looks that you don't have enough rights. You need to launch the 'Uninstaller' program from 'Add or remove programs' to get all privileges. "), exception);
            throw exception;
        }
        catch (Exception exception) {
            throw exception;
        }
        System.out.println("RegistryUninstallerNewListener - beforeDelete.  deleteRegistry");
        this.deleteRegistry();
    }

    @Override
    public void afterDelete(List<File> files, ProgressListener listener) {
        logger.log(Level.FINE, "RegistryUninstallerNewListener - afterDelete.  ");
        super.afterDelete(files, listener);
        this.deleteInstallationInformation();
    }

    private void deleteInstallationInformation() {
        AdxCompUninstallerListener lst = this.getAdxCompUninstallerListener();
        String installPath = lst.getInstallPath();
        File installationinformation = new File(installPath + File.separator + ".installationinformation");
        if (installationinformation.exists()) {
            installationinformation.delete();
        }
    }

    private void deleteRegistry() {
        RegistryHandler myHandlerInstance = this.myhandler.getInstance();
        String unInstallName = myHandlerInstance.getUninstallName();
        String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + unInstallName;
        if (unInstallName == null) {
            logger.log(Level.FINE, "RegistryUninstallerNewListener - Error in deleteRegistry: getUninstallName() is empty");
            System.out.println("RegistryUninstallerNewListener - Error in deleteRegistry: getUninstallName() is empty");
            System.out.println("RegistryUninstallerNewListener - Trying to read InstallPath from install.log");
            AdxCompUninstallerListener lst = this.getAdxCompUninstallerListener();
            String installPath = lst.getInstallPath();
            System.out.println("RegistryUninstallerNewListener - install.log read. installPath:" + installPath);
            if (installPath == null) {
                System.out.println("RegistryUninstallerNewListener - Warning: Cannot read installPath from install.log read.");
                return;
            }
            InstallDataSage data = new InstallDataSage(new DefaultVariables(), Platforms.WINDOWS);
            data.setInstallPath(installPath);
            System.out.println("RegistryUninstallerNewListener - Trying to read " + installPath + "\\.installationinformation");
            InstallationInformationHelper.readInformation(data);
            unInstallName = data.getVariable("UNINSTALL_NAME");
            if (unInstallName == null) {
                unInstallName = data.getVariable("APP_NAME");
            }
            System.out.println("RegistryUninstallerNewListener - unInstallName read from .installationinformation - APP_NAME:" + unInstallName);
            if (unInstallName == null) {
                return;
            }
            keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + unInstallName;
        }
        logger.log(Level.ALL, "RegistryUninstallerNewListener - UninstallName Registry key " + keyName);
        try {
            myHandlerInstance.setRoot(-2147483646);
            if (myHandlerInstance.keyExist(keyName)) {
                if (myHandlerInstance.getValue(keyName, "DisplayVersion") != null) {
                    myHandlerInstance.deleteValue(keyName, "DisplayVersion");
                }
                if (myHandlerInstance.getValue(keyName, "Publisher") != null) {
                    myHandlerInstance.deleteValue(keyName, "Publisher");
                }
                myHandlerInstance.deleteKey(keyName);
                logger.log(Level.FINE, "RegistryUninstallerNewListener - Registry key " + keyName + " deleted");
                System.out.println("RegistryUninstallerNewListener - Registry key " + keyName + " deleted");
            } else {
                logger.log(Level.FINE, "RegistryUninstallerNewListener - Registry key " + keyName + " doesn't exist or not found.");
                System.out.println("RegistryUninstallerNewListener - Registry key " + keyName + " doesn't exist or not found.");
            }
        }
        catch (NativeLibException e) {
            e.printStackTrace();
            logger.log(Level.FINE, "RegistryUninstallerNewListener - Error, registry key " + keyName + " NOT deleted");
            System.out.println("RegistryUninstallerNewListener - Error, registry key " + keyName + " NOT deleted");
        }
    }

    private AdxCompUninstallerListener getAdxCompUninstallerListener() {
        if (this.adxCompUninstallerListener == null) {
            this.adxCompUninstallerListener = new AdxCompUninstallerListener(this.myhandler, this.resources, this.messages, this.prompt);
        }
        return this.adxCompUninstallerListener;
    }

    private String getString(String resourceId, String defaultTranslation) {
        ResourcesHelper helper = new ResourcesHelper(null, this.resources);
        helper.mergeCustomMessages(this.messages);
        String result = helper.getCustomString(resourceId);
        if (result == null) {
            result = defaultTranslation;
        }
        return result;
    }

    protected void emitError(String message, Exception exceptionMesg) {
        PromptUIHandler UIHandler = new PromptUIHandler(this.prompt);
        if (this.prompt != null && UIHandler != null) {
            UIHandler.emitError("Error", message);
        } else {
            System.err.println(message);
        }
        if (exceptionMesg != null) {
            System.err.println(exceptionMesg.getMessage());
        }
    }
}

