/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.sage.izpack.StringUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostValidateSyracuseHostSetup
implements PanelAction {
    private static final Logger logger = Logger.getLogger(PostValidateSyracuseHostSetup.class.getName());
    private static final String prefixLabel = "PostValidateSyracuseHostSetup - ";

    @Override
    public void executeAction(InstallData installData, AbstractUIHandler uiHandler) {
        logger.log(Level.FINE, "PostValidateSyracuseHostSetup - executeAction. uiHandler=" + uiHandler);
        String serverPassPhrase = installData.getVariable("syracuse.certificate.serverpassphrase");
        String result = installData.getVariable("syracuse.certificate.hexserverpassphrase");
        if (!StringUtil.isNullOrBlank(serverPassPhrase) && StringUtil.isNullOrBlank(result)) {
            result = StringUtil.asciiToHex(serverPassPhrase);
            logger.log(Level.FINE, "HexaPassphraseProcessor.process - Value: " + serverPassPhrase + " - Result set 'syracuse.certificate.hexserverpassphrase': " + result);
            installData.setVariable("syracuse.certificate.hexserverpassphrase", result);
        }
        logger.log(Level.FINE, "PostValidateSyracuseHostSetup - executeAction end");
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }
}

