/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.ModifyInstallationUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Properties;

public class CheckMongoDbPortDataValidator
implements DataValidator {
    @Override
    public DataValidator.Status validateData(InstallData adata) {
        InetAddress inet = null;
        String host = "localhost";
        DataValidator.Status retValue = DataValidator.Status.ERROR;
        String value = adata.getVariable("mongodb.service.port");
        boolean updatemode = ModifyInstallationUtil.get(adata);
        if (updatemode) {
            try {
                FileInputStream fin = new FileInputStream(new File(adata.getInstallPath() + File.separator + ".installationinformation"));
                ObjectInputStream oin = new ObjectInputStream(fin);
                List packsinstalled = (List)oin.readObject();
                Properties variables = (Properties)oin.readObject();
                fin.close();
                String oldPort = variables.getProperty("mongodb.service.port");
                if (value.equals(oldPort)) {
                    return DataValidator.Status.OK;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return DataValidator.Status.ERROR;
            }
        }
        try {
            inet = InetAddress.getByName(host);
            ServerSocket socket = new ServerSocket(Integer.parseInt(value), 0, inet);
            if (socket.getLocalPort() > 0) {
                socket.close();
                return DataValidator.Status.OK;
            }
            socket.close();
            return DataValidator.Status.WARNING;
        }
        catch (Exception ex) {
            retValue = DataValidator.Status.ERROR;
            return retValue;
        }
    }

    @Override
    public String getErrorMessageId() {
        return "portvalidatorerror";
    }

    @Override
    public String getWarningMessageId() {
        return "portinuse";
    }

    @Override
    public boolean getDefaultAnswer() {
        return true;
    }
}

