/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.sage.izpack.CheckMongoDbCertificateP12Validator;
import com.sage.izpack.KeyPairGeneratorHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class CheckMongoDbCreateCertsValidator
implements DataValidator {
    private String strMessage = "";
    public static final String strMessageId = "messageid";
    public static final String strMessageValue = "message.oldvalue";

    @Override
    public DataValidator.Status validateData(InstallData adata) {
        try {
            KeyPair pairCA = KeyPairGeneratorHelper.generateRSAKeyPair(4096);
            String countryCode = adata.getVariable("mongodb.ssl.certificate.countrycode");
            String state = adata.getVariable("mongodb.ssl.certificate.state");
            String city = adata.getVariable("mongodb.ssl.certificate.city");
            String organization = adata.getVariable("mongodb.ssl.certificate.organization");
            String organizationalUnit = adata.getVariable("mongodb.ssl.certificate.organisationalunit");
            String name = adata.getVariable("mongodb.ssl.certificate.name");
            String email = adata.getVariable("mongodb.ssl.certificate.email");
            int validity = Integer.parseInt(adata.getVariable("mongodb.ssl.certificate.validity"));
            X509Certificate cacert = KeyPairGeneratorHelper.generateCAV3Certificate(pairCA, countryCode, organization, organizationalUnit, state, city, name, email, validity);
            String strCertPath = adata.getVariable("mongodb.dir.certs");
            File dirCerts = new File(strCertPath);
            if (!dirCerts.exists()) {
                dirCerts.mkdirs();
            }
            FileWriter cacertfile = new FileWriter(strCertPath + File.separator + "ca.cacrt");
            JcaPEMWriter pem = new JcaPEMWriter((Writer)cacertfile);
            pem.writeObject((Object)cacert);
            pem.close();
            String capassphrase = adata.getVariable("mongodb.ssl.capassphrase");
            KeyPairGeneratorHelper.writePrivateKey(strCertPath + File.separator + "ca.key", pairCA, capassphrase.toCharArray());
            KeyPair pairServer = KeyPairGeneratorHelper.generateRSAKeyPair(4096);
            String hostname = adata.getVariable("mongodb.ssl.certificate.hostname");
            String cname = adata.getInfo().getAppName() + " " + adata.getVariable("component.node.name") + " " + hostname;
            adata.setVariable("mongodb.ssl.certificate.cname", cname);
            X509Certificate servercert = KeyPairGeneratorHelper.generateServerV3Certificate(pairServer, countryCode, organization, organizationalUnit, state, city, cname, hostname, null, validity, cacert, pairCA);
            FileWriter servercertfile = new FileWriter(strCertPath + File.separator + hostname + ".crt");
            pem = new JcaPEMWriter((Writer)servercertfile);
            pem.writeObject((Object)servercert);
            pem.close();
            String serverpassphrase = adata.getVariable("mongodb.ssl.serverpassphrase");
            KeyPairGeneratorHelper.writePrivateKey(strCertPath + File.separator + hostname + ".key", pairServer, serverpassphrase.toCharArray());
            adata.setVariable("mongodb.ssl.usecafile", "true");
            File pemKeyFile = new File(strCertPath + File.separator + hostname + ".pem");
            File certFile = new File(strCertPath + File.separator + hostname + ".crt");
            File privKeyFile = new File(strCertPath + File.separator + hostname + ".key");
            KeyPairGeneratorHelper.mergeFiles(new File[]{certFile, privKeyFile}, pemKeyFile);
            KeyPair pairClient = KeyPairGeneratorHelper.generateRSAKeyPair(4096);
            X509Certificate clientcert = KeyPairGeneratorHelper.generateClientV3Certificate(pairClient, countryCode, organization, organizationalUnit, state, city, name, email, validity, cacert, pairCA);
            FileWriter clientcertfile = new FileWriter(strCertPath + File.separator + "client.crt");
            pem = new JcaPEMWriter((Writer)clientcertfile);
            pem.writeObject((Object)clientcert);
            pem.close();
            KeyPairGeneratorHelper.writePrivateKey(strCertPath + File.separator + "client.key", pairClient, null);
            File pemClientKeyFile = new File(strCertPath + File.separator + "client.pem");
            File certClientFile = new File(strCertPath + File.separator + "client.crt");
            File privClientKeyFile = new File(strCertPath + File.separator + "client.key");
            KeyPairGeneratorHelper.mergeFiles(new File[]{certClientFile, privClientKeyFile}, pemClientKeyFile);
            CheckMongoDbCertificateP12Validator.writeP12File(serverpassphrase, adata);
            adata.setVariable("mongodb.ssl.alreadydone", "true");
            return DataValidator.Status.OK;
        }
        catch (Exception ex) {
            this.strMessage = ex.getMessage();
            adata.setVariable(strMessageValue, this.strMessage);
            return DataValidator.Status.ERROR;
        }
    }

    @Override
    public String getErrorMessageId() {
        return strMessageId;
    }

    @Override
    public String getWarningMessageId() {
        return strMessageId;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }
}

