/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.sage.izpack.CDevLibrariesInfosfinder;
import com.sage.izpack.CDevToolsInfosFinder;
import com.sage.izpack.CLoggerUtils;
import com.sage.izpack.CReport;
import com.sage.izpack.CReportWritter;
import com.sage.izpack.CTextLineUtils;
import com.sage.izpack.CWordList;
import com.sage.izpack.GUIComponentSearcher;
import com.sage.izpack.OsVersionHelper;
import com.sage.izpack.StringUtil;
import com.sage.izpack.UserInputPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextPane;

public class CheckJavaWebPrerequisitesValidator
implements DataValidator {
    private static final Logger logger = Logger.getLogger(CheckJavaWebPrerequisitesValidator.class.getName());
    private static final String prefixLabel = "CheckJavaWebPrerequisitesValidator - ";
    private static final int REPORT_WIDTH_200 = 200;
    private static final int REPORT_WIDTH_100 = 120;
    private static final int RESULT_FONT_SIZE_9 = 9;
    private Resources resources;
    private GUIInstallData guiInstallData;
    private InstallData installData;

    public CheckJavaWebPrerequisitesValidator(InstallData installData, Resources resources) {
        this.resources = resources;
        this.installData = installData;
        if (installData instanceof GUIInstallData) {
            this.guiInstallData = (GUIInstallData)installData;
        }
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - CheckJavaWebPrerequisitesValidator. installData=" + installData);
    }

    private String dumpComponents(Container aContainer) {
        return this.dumpComponents(aContainer, new StringBuilder()).toString();
    }

    private StringBuilder dumpComponents(Container aContainer, StringBuilder aSB) {
        for (Component wComponent : aContainer.getComponents()) {
            boolean wIsTextPane = wComponent instanceof JTextPane;
            String wText = "";
            if (wIsTextPane) {
                wText = ((JTextPane)wComponent).getText();
            } else if (wComponent instanceof JLabel) {
                wText = ((JLabel)wComponent).getText();
            }
            aSB.append(CTextLineUtils.toInsecable(String.format("\n- isTextPane=[%-5s] Component=[%-12s][%s]", wIsTextPane, wComponent.getClass().getSimpleName(), wText)));
            if (!(wComponent instanceof Container)) continue;
            this.dumpComponents((Container)wComponent, aSB);
        }
        return aSB;
    }

    private String dumpVariables(InstallData installData) {
        StringBuilder wDump = new StringBuilder();
        Variables wVariables = installData.getVariables();
        int wIdx = 0;
        for (Map.Entry<Object, Object> wEntry : wVariables.getProperties().entrySet()) {
            wDump.append(CTextLineUtils.toInsecable(String.format("\n- %3d[%-60s]=[%s]", ++wIdx, String.valueOf(wEntry.getKey()), String.valueOf(wEntry.getValue()))));
        }
        return wDump.toString();
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "compileprerequisitestesterror";
    }

    private String getOsDetails(InstallData aData) {
        return String.format("%s - %s - %s", aData.getVariable("SYSTEM_os_name"), aData.getVariable("SYSTEM_os_version"), aData.getVariable("SYSTEM_os_arch")).replace('\n', ' ');
    }

    @Override
    public String getWarningMessageId() {
        return "compileprerequisitestesterror";
    }

    private boolean isConsoleMode(InstallData installData) {
        boolean result = this.isMode(installData, "console");
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isConsoleMode() result: " + result);
        return result;
    }

    private boolean isBatchMode(InstallData installData) {
        boolean result = this.isMode(installData, "auto");
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isBatchMode() result: " + result);
        return result;
    }

    private boolean isConsoleOrBatchMode(InstallData installData) {
        return this.isConsoleMode(installData) || this.isBatchMode(installData);
    }

    private boolean isMode(InstallData aData, String occurrence) {
        String wInstaller = aData.getVariable("INSTALLER_MODE");
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isMode(aData: " + aData + " occurrence:" + occurrence + ")   INSTALLER_MODE:" + wInstaller);
        boolean result = false;
        if (wInstaller != null && wInstaller.contains(occurrence)) {
            result = true;
        }
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isMode(occurrence:" + occurrence + ")  return " + result);
        return result;
    }

    private boolean isGuiMode(InstallData installData) {
        boolean result = !this.isConsoleOrBatchMode(installData);
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - isGuiMode() result: " + result);
        return result;
    }

    private IzPanel retrieveCurrentPanel(GUIInstallData guiInstallData, InstallData installData) throws Exception {
        Panel panelFound = null;
        String panelValidator = null;
        for (Panel panel : installData.getPanelsOrder()) {
            List<String> validators = panel.getValidators();
            for (String validator : validators) {
                if (!validator.equals(this.getClass().getName())) continue;
                panelFound = panel;
                panelValidator = validator;
            }
        }
        if (panelFound != null) {
            logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - PanelFound:" + panelFound + " panelValidator:" + panelValidator);
        } else {
            logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - Current panel NOT FOUND. ");
        }
        if (guiInstallData == null && installData instanceof GUIInstallData) {
            guiInstallData = (GUIInstallData)installData;
        }
        if (guiInstallData != null) {
            for (IzPanel wPanel : guiInstallData.getPanels()) {
                UserInputPanel userinput;
                if (!(wPanel instanceof UserInputPanel) || StringUtil.isNullOrBlank((userinput = (UserInputPanel)wPanel).getId()) || !userinput.getId().equals(panelFound.getPanelId())) continue;
                logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - userinput: " + userinput + " userinput.getId(): " + userinput.getId() + " panelFound:" + panelFound);
                return userinput;
            }
        }
        throw new Exception("CheckJavaWebPrerequisitesValidator - Unable to retrieve the current panel");
    }

    private JTextPane searchJTextPaneProgress(Container aContainer) throws Exception {
        return new GUIComponentSearcher<JTextPane>(JTextPane.class, aContainer, 3).search();
    }

    private JTextPane searchJTextPaneResult(Container aContainer) throws Exception {
        return new GUIComponentSearcher<JTextPane>(JTextPane.class, aContainer, 4).search();
    }

    private void setProgress(InstallData installData, String aInfos) throws Exception {
        logger.log(Level.FINE, "CheckJavaWebPrerequisitesValidator - setProgress");
        if (this.isGuiMode(installData)) {
            JTextPane wTextPaneResultLabel = this.searchJTextPaneProgress(this.retrieveCurrentPanel(this.guiInstallData, installData));
            String wText = wTextPaneResultLabel.getText();
            if (wText != null) {
                int wPos = wText.indexOf(58);
                if (wPos > -1) {
                    wText = wText.substring(0, wPos);
                }
            } else {
                wText = "Result";
            }
            wTextPaneResultLabel.setText(String.format("%s: %s", wText, aInfos));
        } else {
            CLoggerUtils.logInfo("Progress: %s", aInfos);
        }
    }

    private void setResult(InstallData installData, boolean aIsOK, CReport aReport) throws Exception {
        IzPanel wPanel = this.retrieveCurrentPanel(this.guiInstallData, installData);
        CLoggerUtils.logInfo("Components of the panel:%s", this.dumpComponents(wPanel));
        JTextPane wJTextPaneResult = this.searchJTextPaneResult(wPanel);
        wJTextPaneResult.setForeground(aIsOK ? Color.BLACK : Color.BLUE);
        wJTextPaneResult.setFont(new Font("Monospaced", 0, 9));
        wJTextPaneResult.setText(aReport.toStringWithoutNow());
    }

    private void LogInfo(InstallData aData, String mesg) {
        if (this.isGuiMode(aData)) {
            CLoggerUtils.logInfo(mesg);
        } else {
            System.out.println(mesg);
        }
    }

    private void LogError(InstallData aData, String mesg) {
        if (this.isGuiMode(aData)) {
            CLoggerUtils.logSevere(mesg);
        } else {
            System.err.println(mesg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataValidator.Status validateData(InstallData aData) {
        boolean wIsRedHatOrOracleLinux;
        this.LogInfo(aData, "Validator begin. aData: " + aData);
        boolean wIsOK = false;
        DataValidator.Status wValidatorStatus = DataValidator.Status.ERROR;
        CReportWritter wReportWritter = null;
        CReport wReport = new CReport(this.getClass().getSimpleName(), this.isConsoleOrBatchMode(aData) ? 120 : 200);
        if (Debug.isTRACE()) {
            wReport.setConsoleLogOn(true);
        } else {
            wReport.setConsoleLogOn(false);
        }
        boolean bl = wIsRedHatOrOracleLinux = OsVersion.IS_REDHAT_LINUX || OsVersionHelper.IS_ORACLE_LINUX;
        if (!wIsRedHatOrOracleLinux) {
            wReport.appendStep("WARNING NOT 'REDHAT_LINUX' OR 'ORACLE_LINUX' : [%s]", this.getOsDetails(aData));
        }
        if (Debug.isTRACE()) {
            wReport.appendStep("Current variables", new Object[0]);
            wReport.append("Variables: %s", this.dumpVariables(aData));
        }
        try {
            wIsOK = this.validPrerequisites(wReport, aData, this.resources);
            wValidatorStatus = wIsOK ? DataValidator.Status.OK : DataValidator.Status.ERROR;
            wReport.append("");
            wReport.append("Validator status = [%s]", wValidatorStatus.name());
            if (!wIsOK) {
                wReportWritter = new CReportWritter(wReport, "_onError");
                wReport.append("OutputFile = [%s]", wReportWritter.getOutputFile());
            }
        }
        catch (Exception e) {
            wReport.appendError(e);
        }
        if (wReportWritter != null) {
            try {
                wReportWritter.write();
                this.LogInfo(aData, String.format("NbWritedBytes = [%s]", Files.size(wReportWritter.getOutputFile().toPath())));
            }
            catch (Exception e) {
                CLoggerUtils.logSevere(e);
            }
        }
        if (this.isGuiMode(aData)) {
            try {
                this.setResult(aData, wIsOK, wReport);
            }
            catch (Exception e) {
                CLoggerUtils.logSevere(e);
            }
        } else if (!wIsOK) {
            this.LogInfo(aData, wReport.toStringWithoutNow());
            this.LogError(aData, "INSTALLATION STOPPED");
        }
        this.LogInfo(aData, "Validator end.");
        return wValidatorStatus;
    }

    private boolean validPrerequisites(CReport aReport, InstallData aData, Resources resources) throws Exception {
        aReport.appendStep("validPrerequisites searching tools", new Object[0]);
        String wToolsDef = aData.getVariable("compile.prerequisites.control.packages.tools");
        CWordList wToolList = new CWordList(aReport, "tool", wToolsDef.split(","));
        wToolList.SetFriendlySuccessMsg(aData.getVariable("compile.prerequisites.control.packages.successmessage"));
        wToolList.SetFriendlyWarningMsg(aData.getVariable("compile.prerequisites.control.packages.warningmessage"));
        this.setProgress(aData, String.format("Searching %d tools : %s", wToolList.size(), wToolsDef));
        aReport.append(wToolList.dumpAsNumberedList());
        String wDevToolsInfos = new CDevToolsInfosFinder(aReport, aData, resources).execute();
        boolean wToolsFound = wToolList.isAllWordsIn(wDevToolsInfos, CWordList.EKindOfFinding.AT_THE_BEGINING_OF_A_LINE);
        this.setProgress(aData, String.format("All tools found=[%b]", wToolsFound));
        aReport.appendStep("validPrerequisites searching libraries", new Object[0]);
        String wLibsDef = aData.getVariable("compile.prerequisites.control.packages.libs");
        CWordList wLibraryList = new CWordList(aReport, "library", wLibsDef.split(","));
        wLibraryList.SetFriendlySuccessMsg(aData.getVariable("compile.prerequisites.control.packages.successmessage"));
        wLibraryList.SetFriendlyWarningMsg(aData.getVariable("compile.prerequisites.control.packages.warningmessage"));
        this.setProgress(aData, String.format("Searching %d libraries : %s", wLibraryList.size(), wLibsDef));
        aReport.append(wLibraryList.dumpAsNumberedList());
        String wDevLibrariesInfos = new CDevLibrariesInfosfinder(aReport, aData, resources).execute();
        boolean wLibraryFound = wLibraryList.isAllWordsIn(wDevLibrariesInfos, CWordList.EKindOfFinding.AT_THE_BEGINING_OF_A_LINE);
        this.setProgress(aData, String.format("All libraries found=[%b]", wLibraryFound));
        this.setProgress(aData, "");
        return wToolsFound && wLibraryFound;
    }
}

