/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.sage.izpack.CTextLineUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class CLoggerUtils {
    public static final String SIMPLE_FORMATTER_FORMAT = "%1$tY/%1$tm/%1$td; %1$tH:%1$tM:%1$tS:%1$tL; %4$7.7s; %3$16.016s; %2$54.54s; %5$s%6$s%n";
    private static final Logger sLoggerRoot = Logger.getLogger("");

    public static String dumpStackTrace(Throwable e) {
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static String log(Level aLevel, String aText) {
        sLoggerRoot.log(aLevel, aText);
        return aText;
    }

    public static String logBanner(Level aLevel, String aText) {
        CLoggerUtils.log(aLevel, CTextLineUtils.generateLineFull('#', 80));
        CLoggerUtils.log(aLevel, CTextLineUtils.generateLineBeginEnd('#', 80));
        CLoggerUtils.log(aLevel, CTextLineUtils.generateLineBeginEnd('#', 80, aText));
        CLoggerUtils.log(aLevel, CTextLineUtils.generateLineBeginEnd('#', 80));
        CLoggerUtils.log(aLevel, CTextLineUtils.generateLineFull('#', 80));
        return aText;
    }

    public static String logBanner(Level aLevel, String aFormat, Object ... aArgs) {
        return CLoggerUtils.logBanner(aLevel, String.format(aFormat, aArgs));
    }

    public static String logInfo(String aText) {
        return CLoggerUtils.log(Level.INFO, aText);
    }

    public static String logInfo(String aFormat, Object ... aArgs) {
        return CLoggerUtils.log(Level.INFO, String.format(aFormat, aArgs));
    }

    public static String logSevere(String aText) {
        return CLoggerUtils.log(Level.SEVERE, aText);
    }

    public static String logSevere(String aFormat, Object ... aArgs) {
        return CLoggerUtils.log(Level.SEVERE, String.format(aFormat, aArgs));
    }

    public static String logSevere(Throwable e) {
        return CLoggerUtils.log(Level.SEVERE, CLoggerUtils.dumpStackTrace(e));
    }

    private static String setFormatOfSimpleFormatter(String aFormat) throws Exception {
        return CLoggerUtils.setPrivateStaticFinalString(SimpleFormatter.class, "format", aFormat);
    }

    private static String setPrivateStaticFinalString(Class<?> aClass, String aFieldName, String aValue) throws Exception {
        try {
            int wOriginalModifiers;
            Field wTargetField = aClass.getDeclaredField(aFieldName);
            boolean wHasToRemovePrivate = true;
            if (wHasToRemovePrivate) {
                wTargetField.setAccessible(true);
            }
            boolean wHasToRemoveFinal = ((wOriginalModifiers = wTargetField.getModifiers()) & 0xFFFFFFEF) != wOriginalModifiers;
            Field wModifiersField = null;
            if (wHasToRemoveFinal) {
                wModifiersField = Field.class.getDeclaredField("modifiers");
                wModifiersField.setAccessible(true);
                wModifiersField.setInt(wTargetField, wTargetField.getModifiers() & 0xFFFFFFEF);
            }
            String wOldValue = String.valueOf(wTargetField.get(null));
            wTargetField.set(null, aValue);
            String wNewValue = String.valueOf(wTargetField.get(null));
            boolean wModified = aValue.equals(wNewValue);
            return String.format("Modified static fied: [%s.%s]\n - Modified=[%b]\n - NewValue=[%s]\n - OldValue=[%s]", aClass.getSimpleName(), wTargetField.getName(), wModified, wNewValue, wOldValue);
        }
        catch (Exception e) {
            throw new Exception(String.format("ERROR: Unable to set the final field [%s.%s]", aClass.getSimpleName(), aFieldName), e);
        }
    }

    private CLoggerUtils() {
    }
}

