/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.rule;

import com.izforge.izpack.api.exception.IzPackException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldSpec {
    private final Type type;
    private final int columns;
    private final int length;
    private static final Logger logger = Logger.getLogger(FieldSpec.class.getName());
    private static final int MIN_TOKENS = 2;
    private static final int MAX_TOKENS = 3;

    public FieldSpec(String spec) {
        StringTokenizer tokenizer = new StringTokenizer(spec, ":");
        int tokens = tokenizer.countTokens();
        if (tokens < 2 || tokens > 3) {
            throw new IzPackException("Invalid no. of tokens: " + tokens + " in rule: " + spec);
        }
        String token = tokenizer.nextToken().toUpperCase();
        this.type = this.getType(token, spec);
        token = tokenizer.nextToken();
        this.columns = this.getColumns(token, spec);
        this.length = tokens == 3 ? ("U".equals(token = tokenizer.nextToken().toUpperCase()) ? -1 : this.getLength(token, spec)) : -1;
    }

    public FieldSpec(Type type, int columns, int length) {
        this.type = type;
        this.columns = columns;
        this.length = length;
    }

    public static FieldSpec parse(String spec) {
        FieldSpec result = null;
        try {
            result = new FieldSpec(spec);
        }
        catch (IzPackException exception) {
            logger.log(Level.FINE, "Failed to parse: " + spec, exception);
        }
        return result;
    }

    public Type getType() {
        return this.type;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnlimitedLength() {
        return this.length == -1;
    }

    public boolean validate(String value) {
        boolean result = true;
        if (value != null && (this.length == -1 || value.length() <= this.length)) {
            if (this.type == Type.NUMERIC) {
                for (int i = 0; i < value.length(); ++i) {
                    if (Character.isDigit(value.charAt(i))) continue;
                    result = false;
                    break;
                }
            } else if (this.type == Type.HEX) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = Character.toUpperCase(value.charAt(i));
                    if (Character.isDigit(ch) || ch == 'A' || ch == 'B' || ch == 'C' || ch == 'D' || ch == 'E' || ch == 'F') continue;
                    result = false;
                    break;
                }
            } else if (this.type == Type.ALPHA) {
                for (int i = 0; i < value.length(); ++i) {
                    if (Character.isLetter(value.charAt(i))) continue;
                    result = false;
                    break;
                }
            } else if (this.type == Type.ALPHANUMERIC) {
                for (int i = 0; i < value.length(); ++i) {
                    if (Character.isLetterOrDigit(value.charAt(i))) continue;
                    result = false;
                    break;
                }
            } else if (this.type != Type.OPEN) {
                logger.warning("Invalid field type: " + (Object)((Object)this.type));
                result = false;
            }
        }
        return result;
    }

    private Type getType(String type, String spec) {
        Type result;
        if ("N".equals(type)) {
            result = Type.NUMERIC;
        } else if ("H".equals(type)) {
            result = Type.HEX;
        } else if ("A".equals(type)) {
            result = Type.ALPHA;
        } else if ("O".equals(type)) {
            result = Type.OPEN;
        } else if ("AN".equals(type)) {
            result = Type.ALPHANUMERIC;
        } else {
            throw new IzPackException("Invalid field type: " + type + " in rule: " + spec);
        }
        return result;
    }

    private int getColumns(String values, String spec) {
        int result;
        try {
            result = Integer.parseInt(values);
        }
        catch (NumberFormatException exception) {
            throw new IzPackException("Unable to determine the size of the field in rule:" + spec, exception);
        }
        return result;
    }

    private int getLength(String value, String spec) {
        int result;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            throw new IzPackException("Unable to determine the length of the field in rule:" + spec, exception);
        }
        return result;
    }

    public static enum Type {
        NUMERIC,
        ALPHA,
        ALPHANUMERIC,
        HEX,
        OPEN;

    }
}

