/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.file;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.file.FileFieldConfig;
import java.io.File;

public class AbstractFileField
extends Field {
    private final String fileExtension;
    private final String fileExtensionDescription;
    protected final boolean allowEmptyValue;
    protected final boolean mustExist;

    public AbstractFileField(FileFieldConfig config, InstallData installData) {
        super(config, installData);
        this.fileExtension = config.getFileExtension();
        this.fileExtensionDescription = config.getFileExtensionDescription();
        this.allowEmptyValue = config.getAllowEmptyValue();
        this.mustExist = config.mustExist();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getFileExtensionDescription() {
        return this.fileExtensionDescription;
    }

    public boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public File getAbsoluteFile(String path) {
        if (path.startsWith("~")) {
            String home = System.getProperty("user.home");
            path = home + path.substring(1);
        }
        return new File(path).getAbsoluteFile();
    }
}

