/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldReader;
import com.izforge.izpack.panels.userinput.field.SimpleChoiceReader;
import com.izforge.izpack.panels.userinput.field.SimpleFieldReader;
import com.izforge.izpack.panels.userinput.field.TextAreaReader;
import com.izforge.izpack.panels.userinput.field.button.ButtonField;
import com.izforge.izpack.panels.userinput.field.button.ButtonFieldReader;
import com.izforge.izpack.panels.userinput.field.check.CheckField;
import com.izforge.izpack.panels.userinput.field.check.CheckFieldReader;
import com.izforge.izpack.panels.userinput.field.combo.ComboField;
import com.izforge.izpack.panels.userinput.field.custom.CustomField;
import com.izforge.izpack.panels.userinput.field.custom.CustomFieldReader;
import com.izforge.izpack.panels.userinput.field.divider.Divider;
import com.izforge.izpack.panels.userinput.field.divider.DividerReader;
import com.izforge.izpack.panels.userinput.field.file.DirField;
import com.izforge.izpack.panels.userinput.field.file.DirFieldReader;
import com.izforge.izpack.panels.userinput.field.file.FileField;
import com.izforge.izpack.panels.userinput.field.file.FileFieldReader;
import com.izforge.izpack.panels.userinput.field.file.MultipleFileField;
import com.izforge.izpack.panels.userinput.field.file.MultipleFileFieldReader;
import com.izforge.izpack.panels.userinput.field.password.PasswordGroupField;
import com.izforge.izpack.panels.userinput.field.password.PasswordGroupFieldReader;
import com.izforge.izpack.panels.userinput.field.radio.RadioField;
import com.izforge.izpack.panels.userinput.field.rule.RuleField;
import com.izforge.izpack.panels.userinput.field.rule.RuleFieldReader;
import com.izforge.izpack.panels.userinput.field.search.SearchField;
import com.izforge.izpack.panels.userinput.field.search.SearchFieldReader;
import com.izforge.izpack.panels.userinput.field.space.Spacer;
import com.izforge.izpack.panels.userinput.field.statictext.StaticText;
import com.izforge.izpack.panels.userinput.field.statictext.StaticTextFieldReader;
import com.izforge.izpack.panels.userinput.field.text.TextArea;
import com.izforge.izpack.panels.userinput.field.text.TextField;
import com.izforge.izpack.panels.userinput.field.title.TitleField;
import com.izforge.izpack.panels.userinput.field.title.TitleFieldReader;
import com.izforge.izpack.util.PlatformModelMatcher;

public class FieldFactory {
    private final Config config;
    private final InstallData installData;
    private final PlatformModelMatcher matcher;

    public FieldFactory(Config config, InstallData installData, PlatformModelMatcher matcher) {
        this.config = config;
        this.installData = installData;
        this.matcher = matcher;
    }

    public Field create(IXMLElement element) {
        Field result;
        Type type;
        String value = this.config.getAttribute(element, "type");
        try {
            type = Type.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            throw new IzPackException("Invalid field type: " + value + " in " + this.config.getContext(element));
        }
        switch (type) {
            case BUTTON: {
                result = new ButtonField(new ButtonFieldReader(element, this.config, this.installData), this.installData);
                break;
            }
            case CHECK: {
                result = new CheckField(new CheckFieldReader(element, this.config), this.installData);
                break;
            }
            case COMBO: {
                result = new ComboField(new SimpleChoiceReader(element, this.config, this.installData), this.installData);
                break;
            }
            case CUSTOM: {
                result = new CustomField(new CustomFieldReader(element, this.config, this.matcher, this.installData), this.installData);
                break;
            }
            case DIR: {
                result = new DirField(new DirFieldReader(element, this.config), this.installData);
                break;
            }
            case DIVIDER: {
                result = new Divider(new DividerReader(element, this.config), this.installData);
                break;
            }
            case FILE: {
                result = new FileField(new FileFieldReader(element, this.config), this.installData);
                break;
            }
            case MULTIFILE: {
                result = new MultipleFileField(new MultipleFileFieldReader(element, this.config), this.installData);
                break;
            }
            case PASSWORD: {
                result = new PasswordGroupField(new PasswordGroupFieldReader(element, this.config), this.installData);
                break;
            }
            case RADIO: {
                result = new RadioField(new SimpleChoiceReader(element, this.config, this.installData), this.installData);
                break;
            }
            case RULE: {
                result = new RuleField(new RuleFieldReader(element, this.config), this.installData);
                break;
            }
            case SEARCH: {
                result = new SearchField(new SearchFieldReader(element, this.config, this.matcher), this.installData);
                break;
            }
            case SPACE: {
                result = new Spacer(new SimpleFieldReader(element, this.config), this.installData);
                break;
            }
            case STATICTEXT: {
                result = new StaticText(new StaticTextFieldReader(element, this.config), this.installData);
                break;
            }
            case TEXT: {
                result = new TextField(new FieldReader(element, this.config), this.installData);
                break;
            }
            case TEXTAREA: {
                result = new TextArea(new TextAreaReader(element, this.config), this.installData);
                break;
            }
            case TITLE: {
                result = new TitleField(new TitleFieldReader(element, this.config), this.installData);
                break;
            }
            default: {
                throw new IzPackException("Unsupported field type: " + value + " in " + this.config.getContext(element));
            }
        }
        return result;
    }

    static enum Type {
        BUTTON,
        CHECK,
        COMBO,
        CUSTOM,
        DIR,
        DIVIDER,
        FILE,
        MULTIFILE,
        PASSWORD,
        RADIO,
        RULE,
        SPACE,
        SEARCH,
        STATICTEXT,
        TEXT,
        TITLE,
        TEXTAREA;

    }
}

