/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.checkedhello;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.util.IoHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistryHelper {
    private final RegistryHandler handler;
    private final InstallData installData;
    private static final Logger log = Logger.getLogger(RegistryHelper.class.getName());
    private static final String UNINSTALL_STRING = "UninstallString";
    private static final String INSTALL_PATH = "$INSTALL_PATH";

    public RegistryHelper(RegistryDefaultHandler handler, InstallData installData) {
        this.handler = handler.getInstance();
        this.installData = installData;
    }

    public boolean isRegistered() throws NativeLibException {
        String keyName;
        String uninstallName;
        boolean result = false;
        if (this.handler != null && (uninstallName = this.getUninstallName()) != null && (this.exists(-2147483646, keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstallName, UNINSTALL_STRING) || this.exists(-2147483647, keyName, UNINSTALL_STRING))) {
            result = true;
        }
        return result;
    }

    public String getUninstallName() {
        return this.handler != null ? this.handler.getUninstallName() : null;
    }

    public String getInstallationPath() throws NativeLibException {
        String result = null;
        String command = this.getUninstallCommand();
        if (command != null) {
            int start = command.lastIndexOf("-jar ");
            if (start != -1 && start < command.length() - 5) {
                int end;
                String path = command.substring(start + 5).trim();
                if (path.startsWith("\"")) {
                    path = path.substring(1).trim();
                }
                if ((end = path.indexOf("uninstaller")) >= 0) {
                    result = path.substring(0, end - 1);
                    String uninstallerPath = this.installData.getInfo().getUninstallerPath();
                    if (uninstallerPath != null && uninstallerPath.startsWith(INSTALL_PATH)) {
                        uninstallerPath = IoHelper.translatePath(uninstallerPath);
                        if (result.endsWith(uninstallerPath = uninstallerPath.substring(INSTALL_PATH.length()))) {
                            result = result.substring(0, result.length() - uninstallerPath.length());
                        }
                    }
                }
            }
            if (result == null) {
                log.log(Level.WARNING, "Cannot determine installation path from: " + command);
            }
        }
        return result;
    }

    public String getUninstallCommand() throws NativeLibException {
        String result = null;
        if (this.handler != null) {
            String uninstallName = this.handler.getUninstallName();
            if (uninstallName == null) {
                throw new IllegalStateException("Cannot determine uninstallation name");
            }
            String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + uninstallName;
            if (!this.exists(-2147483646, keyName, UNINSTALL_STRING) && !this.exists(-2147483647, keyName, UNINSTALL_STRING)) {
                log.log(Level.INFO, "Cannot determine previous installation path of " + uninstallName);
            } else {
                result = this.handler.getValue(keyName, UNINSTALL_STRING).getStringData();
            }
        }
        return result;
    }

    public String updateUninstallName() throws NativeLibException {
        String result = null;
        if (this.handler != null) {
            String uninstallName = this.handler.getUninstallName();
            if (uninstallName == null) {
                throw new IllegalStateException("Cannot determine uninstallation name");
            }
            int count = 1;
            while (true) {
                String newUninstallName = uninstallName + "(" + count + ")";
                String keyName = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + newUninstallName;
                this.handler.setRoot(-2147483646);
                if (!this.handler.keyExist(keyName)) {
                    this.handler.setUninstallName(newUninstallName);
                    result = newUninstallName;
                    break;
                }
                ++count;
            }
        }
        return result;
    }

    protected boolean exists(int root, String key, String value) throws NativeLibException {
        this.handler.setRoot(root);
        return this.handler.valueExist(key, value);
    }
}

